library(ggplot2)
library(idsThemeR)

if (interactive()) {
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
     colour = factor(gear))) + facet_wrap(~am)
p + theme_ids() + scale_colour_ids()
p + theme_ids(style = "dark") +
  scale_colour_ids("dark")

dtemp <- data.frame(Months = factor(rep(substr(month.name, 1, 3), 4),
                                    levels = substr(month.name, 1, 3)),
                    City = rep(c("Tokyo", "New York", "Berlin", "London"),
                               each = 12),
                    Temperature = c(7.0, 6.9, 9.5, 14.5, 18.2, 21.5,
                             25.2, 26.5, 23.3, 18.3, 13.9, 9.6,
                             -0.2, 0.8, 5.7, 11.3, 17.0, 22.0,
                             24.8, 24.1, 20.1, 14.1, 8.6, 2.5,
                             -0.9, 0.6, 3.5, 8.4, 13.5, 17.0,
                             18.6, 17.9, 14.3, 9.0, 3.9, 1.0,
                             3.9, 4.2, 5.7, 8.5, 11.9, 15.2,
                             17.0, 16.6, 14.2, 10.3, 6.6, 4.8))

ggplot(dtemp, aes(x = Months, y = Temperature, group = City, color = City)) +
  geom_line() +
  geom_point(size = 1.1) +
  ggtitle("Monthly Average Temperature", subtitle="Source: WorldClimate.com") +
  theme_ids() +
  scale_colour_ids()

}

