% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharter-themes.R
\name{hc_theme_ids_dark}
\alias{hc_theme_ids_dark}
\title{Dark IDS theme for \link[highcharter]{highcharter}}
\usage{
hc_theme_ids_dark(
  fontFamily = "Fira Sans Condensed",
  fontSize = "medium",
  textColor = textColorDark,
  lowContrastColor = lowContrastColorDark,
  highContrastColor = highContrastColorDark,
  palette = idsPalette(),
  backgroundColor = list(linearGradient = list(x1 = 0, y1 = 1, x2 = 1, y2 = 0), stops =
    list(list(0, "#2a2a2b"), list(1, "#3e3e3e"))),
  titleColor = textColor,
  subtitleColor = titleColor,
  gridLineColor = lowContrastColor,
  axisLabelColor = textColor,
  axisLineColor = lowContrastColor,
  minorGridLineColor = "#505053",
  tickColor = lowContrastColor,
  axisTitleColor = axisLabelColor,
  tooltipBackgroundColor = "rgba(0, 0, 0, 0.85)",
  tooltipColor = textColor,
  dataLabelColor = textColor,
  boxplotFillColor = "#505053",
  candlestickColor = highContrastColor,
  errorbarColor = candlestickColor,
  legendColor = textColor,
  legendHoverColor = highContrastColor,
  legendHiddenColor = lowContrastColor,
  creditsColor = lowContrastColor,
  burgerMenuBackground = backgroundColor,
  ...
)
}
\arguments{
\item{fontFamily}{font family}

\item{fontSize}{default font size}

\item{textColor}{default text color}

\item{lowContrastColor}{color with low contrast to background}

\item{highContrastColor}{color with high contrast to background}

\item{palette}{array of colors to be used for different series}

\item{backgroundColor}{background color}

\item{titleColor}{color of the title text}

\item{subtitleColor}{color of the subtitle text}

\item{gridLineColor}{color of grid lines}

\item{axisLabelColor}{color of the axis labels}

\item{axisLineColor}{color of the axis lines}

\item{minorGridLineColor}{color of minor grid lines}

\item{tickColor}{color of axis ticks}

\item{axisTitleColor}{color of axis titles}

\item{tooltipBackgroundColor}{background color for tool tips}

\item{tooltipColor}{foreground color for tool tips}

\item{dataLabelColor}{color of data point labels}

\item{boxplotFillColor}{color for box plot fills}

\item{candlestickColor}{color the candle stick part of error bars}

\item{errorbarColor}{error bar color}

\item{legendColor}{series legend label color}

\item{legendHoverColor}{mouse over series legend label color}

\item{legendHiddenColor}{hidden series legend label color}

\item{creditsColor}{color of the credits}

\item{burgerMenuBackground}{burger menu background color}

\item{...}{named arguments to modify the theme}
}
\description{
Dark IDS theme for \link[highcharter]{highcharter}
}
\examples{
library(tidyverse)
library(highcharter)
highcharts_demo() \%>\%
  hc_add_theme(hc_theme_ids_dark())
}
