% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharter-themes.R
\name{hc_theme_ids_light}
\alias{hc_theme_ids_light}
\title{Light IDS theme for \link[highcharter]{highcharter}}
\usage{
hc_theme_ids_light(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=hc_theme_ids_dark]{hc_theme_ids_dark}}
  \describe{
    \item{\code{fontFamily}}{font family}
    \item{\code{fontSize}}{default font size}
    \item{\code{textColor}}{default text color}
    \item{\code{lowContrastColor}}{color with low contrast to background}
    \item{\code{highContrastColor}}{color with high contrast to background}
    \item{\code{palette}}{array of colors to be used for different series}
    \item{\code{backgroundColor}}{background color}
    \item{\code{titleColor}}{color of the title text}
    \item{\code{subtitleColor}}{color of the subtitle text}
    \item{\code{gridLineColor}}{color of grid lines}
    \item{\code{axisLabelColor}}{color of the axis labels}
    \item{\code{axisLineColor}}{color of the axis lines}
    \item{\code{minorGridLineColor}}{color of minor grid lines}
    \item{\code{tickColor}}{color of axis ticks}
    \item{\code{axisTitleColor}}{color of axis titles}
    \item{\code{tooltipBackgroundColor}}{background color for tool tips}
    \item{\code{tooltipColor}}{foreground color for tool tips}
    \item{\code{dataLabelColor}}{color of data point labels}
    \item{\code{boxplotFillColor}}{color for box plot fills}
    \item{\code{candlestickColor}}{color the candle stick part of error bars}
    \item{\code{errorbarColor}}{error bar color}
    \item{\code{legendColor}}{series legend label color}
    \item{\code{legendHoverColor}}{mouse over series legend label color}
    \item{\code{legendHiddenColor}}{hidden series legend label color}
    \item{\code{creditsColor}}{color of the credits}
    \item{\code{burgerMenuBackground}}{burger menu background color}
  }}
}
\description{
See \code{\link{hc_theme_ids_dark}} for further documentation.
}
\examples{
library(tidyverse)
library(highcharter)
highcharts_demo() \%>\%
  hc_add_theme(hc_theme_ids_light())
}
