#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use File::Basename;
use File::Spec::Functions;
use Data::Dumper;
use utf8;

use Test::Output;
use Mojo::JSON 'decode_json';
use Mojo::Util qw'decode encode';

my $script = catfile(dirname(__FILE__), '..', 'script', 'cosmasvc2koralquery');
my $list1 = catfile(dirname(__FILE__), 'data', 'list2.def');

# Check STDOUT
stdout_like(
  sub {
    system($script, 'def', $list1);
  },
  qr!^\{\"\@context\".+?\}$!,
  "check stdout"
);

# Check JSON
my $json = decode_json(join('', `$script def $list1`));

is($json->{'collection'}->{'@type'}, 'koral:docGroup', 'type');
is($json->{'collection'}->{'operation'}, 'operation:or', 'operation');

my $op1 = $json->{'collection'}->{'operands'}->[0];
is($op1->{'@type'}, 'koral:doc', 'type');
is($op1->{'key'}, 'docSigle', 'key');
is($op1->{'match'}, 'match:eq', 'match');
is($op1->{'value'}->[0], "BRZ05/SEP", 'value');
is($op1->{'value'}->[1], ,"BRZ05/OKT", 'value');
is($op1->{'value'}->[-1], ,"BRZ08/FEB", 'value');

my $op2 = $json->{'collection'}->{'operands'}->[1];
is($op2->{'@type'}, 'koral:doc', 'type');
is($op2->{'key'}, 'textSigle', 'key');
is($op2->{'match'}, 'match:eq', 'match');
is($op2->{'value'}->[0], "B19/AUG/01665", 'value');
is($op2->{'value'}->[1], ,"B19/AUG/01666", 'value');

my $list3 = catfile(dirname(__FILE__), 'data', 'list3.def');


# Check JSON
# Only return extended area
$json = decode_json(join('', `$script def $list3`));

is($json->{'collection'}->{'@type'}, 'koral:doc', 'type');


is($json->{'collection'}->{'_comment'}, 'name:"VAS-N91 (Stand \"2013\", korr. 2017)"', 'type');

$op1 = $json->{'collection'};
is($op1->{'@type'}, 'koral:doc', 'type');
is($op1->{'key'}, 'textSigle', 'key');
is($op1->{'match'}, 'match:eq', 'match');
is($op1->{'value'}->[0], "A00/APR/23232", 'value');
is($op1->{'value'}->[1], "A00/APR/23233", 'value');

my $list4 = catfile(dirname(__FILE__), 'data', 'list4.def');

# Only contains intended area
$json = decode_json(join('', `$script def $list4`));

is($json->{'collection'}->{'@type'}, 'koral:docGroup', 'type');
is($json->{'collection'}->{'_comment'}, 'name:"VAS N91"', 'name');
like($json->{'collection'}->{'_comment'}, qr!^name:"VAS N91"!, 'name');


my $bz = $json->{'collection'}->{operands}->[0]->{operands}->[0];
is($bz->{operation}, 'operation:and', 'Intersection');
is(scalar @{$bz->{operands}}, 3, 'Flatten operands');

my $faz = $json->{'collection'}->{operands}->[0]->{operands}->[1];
is($faz->{'@type'}, 'koral:doc', 'DocVec');
is($faz->{value}->[0], 'F97', 'Value');
is($faz->{value}->[1], 'F99', 'Value');

my $list_long = catfile(dirname(__FILE__), 'data', 'corp-w-short.def');
$json = decode_json(join('', `$script def $list_long`))->{collection};
is($json->{'@type'}, 'koral:doc', 'DocVec');
is($json->{key}, 'textSigle', 'Key');
is($json->{value}->[0], 'A97/APR/00001', 'Value');
is($json->{value}->[1], 'A97/APR/00002', 'Value');
is($json->{value}->[-1], 'A97/APR/01001', 'Value');

my $corpa = catfile(dirname(__FILE__), 'data', 'corp-a.def');
$json = decode_json(encode('utf-8',join('', `$script def $corpa`)));

is($json->{'collection'}->{'@type'}, 'koral:doc', 'type');
is($json->{'collection'}->{'key'}, 'pubPlaceKey', 'type');
is($json->{'collection'}->{'value'}, 'AT', 'type');
is($json->{'collection'}->{'_comment'}, 'name:"Korpora aus Österreich"', 'type');

my $corpw = catfile(dirname(__FILE__), 'data', 'corp-w-vas-n91-kor17');

$json = decode_json(encode('utf-8',join('', `$script def $corpw`)));

is($json->{'collection'}->{'@type'}, 'koral:doc', 'type');
is($json->{'collection'}->{'key'}, 'textSigle', 'type');
is($json->{'collection'}->{'value'}->[0], 'A00/APR/23232', 'type');
is($json->{'collection'}->{'_comment'}, 'name:"VAS-N91 (Stand 2013, korr. 2017)"', 'type');

my $corpw2 = catfile(dirname(__FILE__), 'data', 'corp-w-cultwar.beziehung.def');
$json = decode_json(encode('utf-8',join('', `$script def $corpw2`)));

is($json->{'collection'}->{'@type'}, 'koral:doc', 'type');
is($json->{'collection'}->{'key'}, 'docSigle', 'type');
is($json->{'collection'}->{'value'}->[0], 'FSP/SCP', 'type');
is($json->{'collection'}->{'_comment'}, 'name:"Culture War: Beziehung"', 'type');



done_testing;
__END__
