#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use File::Basename;
use File::Spec::Functions;
use Data::Dumper;
use File::Temp qw/tempdir/;

use Test::Output;
use Mojo::JSON 'decode_json';

my $script = catfile(dirname(__FILE__), '..', 'script', 'cosmasvc2koralquery');
my $copysrc = catdir(dirname(__FILE__), 'data');
my $list1 = catfile(dirname(__FILE__), 'data', 'list-example.ls');
my $output = tempdir( CLEANUP => 1 );

my @call = ($script, 'list', $list1, '--copy-src', $copysrc, '--output', $output);

# Check STDOUT
stderr_like(
  sub {
    system(@call);
  },
  qr!redabs is not yet supported!,
  "check stdout"
);

# Check JSON
my $protocol = join('', `@call`);

like($protocol, qr!bih from regex!);
ok(-f catfile($output, 'bih.jsonld'));
like($protocol, qr!bio from regex!);
ok(-f catfile($output, 'bio.jsonld'));
like($protocol, qr!bio-pub from regex!);
ok(-f catfile($output, 'bio-pub.jsonld'));
like($protocol, qr!l from regex!);
ok(-f catfile($output, 'l.jsonld'));
like($protocol, qr!dpa from regex!);
ok(-f catfile($output, 'dpa.jsonld'));
like($protocol, qr!fsp from regex!);
ok(-f catfile($output, 'fsp.jsonld'));
like($protocol, qr!fsp-pub from regex!);
ok(-f catfile($output, 'fsp-pub.jsonld'));
like($protocol, qr!kjl from regex!);
ok(-f catfile($output, 'kjl.jsonld'));
like($protocol, qr!thm-lit from regex!);
ok(-f catfile($output, 'thm-lit.jsonld'));
like($protocol, qr!wxx11 from regex!);
ok(-f catfile($output, 'wxx11.jsonld'));
like($protocol, qr!zca from regex!);
ok(-f catfile($output, 'zca.jsonld'));
like($protocol, qr!list2 from def-file!);
ok(-f catfile($output, 'list2.jsonld'));
like($protocol, qr!list5 from def-file!);
ok(-f catfile($output, 'list5.jsonld'));
like($protocol, qr!misc-lit from regex!);
ok(-f catfile($output, 'misc-lit.jsonld'));

done_testing;
__END__


