#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use KorAP::ScriptLoad;
use Mojo::JSON qw'decode_json encode_json';
use Mojo::File qw'path';
use File::Temp qw/tempdir/;
use File::Basename;
use File::Spec::Functions;

my $rf = \&KorAP::ScriptLoad::_parse_load;

my ($name, $desc, @def) = $rf->(q!echo -e "W-gesamt-2022-I - W-gesamt von Release DeReKo-2022-I _Blue_\tLOAD('corp-w-gesamt.2022-i.21.06.22')" >> $CDFile   !);

is($name, 'W-gesamt-2022-I');
is($desc, 'W-gesamt von Release DeReKo-2022-I');
is($def[0], 'corp-w-gesamt.2022-i.21.06.22');

($name, $desc, @def) = $rf->(q! echo -e "W-gesamt-2017-I - W-gesamt von Release DeReKo-2017-I _Blue_\tLOAD('corp-w-gesamt.2017-i.17.10.17')\tG_UWV" >> $CDFile   !);

is($name, 'W-gesamt-2017-I');
is($desc, 'W-gesamt von Release DeReKo-2017-I');
is($def[0], 'corp-w-gesamt.2017-i.17.10.17');

($name, $desc, @def) = $rf->(q! echo -e "lit - Belletristik/Trivialliteratur _Maroon_ \tLOAD('bih bio bio-pub div div-pub gr1 gri hes kjl les wam thm-lit misc-lit')" >>$CDFile     !);

is($name, 'lit');
is($desc, 'Belletristik/Trivialliteratur');
is($def[0], 'bih');
is($def[-1], 'misc-lit');

($name, $desc, @def) = $rf->(q!echo -e "W2-öffentlich - alle öffentlichen Korpora des Archivs W2 (mit Neuakquisitionen) _B__BLUE_\tLOAD('aan aaz abo alz art azm baz bdz bee bez bku bla bli boz brg brm bru brw bun bup bwa bsz bze chk cou ctb dak daz dec dki dnn dol dpr dog edf eft elf elt ett eut euw fis fmt fnp fom fra frt gal gaz ge geo ges gingko gng gob gsp gta gtb hab hau hfz hhz hkr hrz hst htb hzs hzw hzz ix k kaz ksa kur ktz lah lan laz lmd lru msp ndo neo noz nwt osz paz ph pmm scw stb stg tvd vbw vzs w was weo div')" >>$CDFile  !);

is($name, 'W2-öffentlich');
is($desc, 'alle öffentlichen Korpora des Archivs W2 (mit Neuakquisitionen)');
is($def[0], 'aan');
is($def[-1], 'div');

($name, $desc, @def) = $rf->(q!div - Belletristik des 20. und 21. Jahrhunderts: Diverse Schriftsteller LOAD('div div-pub')!);

is($name, 'div');
is($desc, 'Belletristik des 20. und 21. Jahrhunderts: Diverse Schriftsteller');
is($def[0], 'div');
is($def[-1], 'div-pub');


($name, $desc, @def) = $rf->(q!echo -e "N-gesamt - alle Neuakquisitionen von DeReKo-2024-I _B__Blue_\tLOAD('bih bio bio-pub l bvz brz bzk b ct cz dck div div-pub dkg dpa p erk flt faz foc frr fsp fsp-pub goe gr1 gri haz hbk hes hmp iko ix kic kjl klz ksp les lim lmd ltb mk1 mk2 mld m neu new ng nku nkz non nun nuz nzf nzs nzz oon pp prf rei rhp rhz sbl sbn a sid soz s spk sol ste stg u tas t thm ttz van vdi wam wkb wkd wkv wxx11 wwo zca zcw z zge e zwi -corp-w-gesamt.2023-i.16.03.23')" >>$CDFile!);

is($name, 'N-gesamt');
is($desc, 'alle Neuakquisitionen von DeReKo-2024-I');
is($def[0], 'bih');
is($def[-1], '-corp-w-gesamt.2023-i.16.03.23');


# Load script file
my $script_file = catfile(dirname(__FILE__), 'data', 'doVirtBms.w.all.2024-I');
my $output = tempdir( CLEANUP => 1 );

my $load = KorAP::ScriptLoad->new(
  file => $script_file,
  output => $output
);

$load->parse;

ok(-e catfile($output, 'wkd.jsonld'));
ok(-e catfile($output, 'taz.jsonld'));
ok(-e catfile($output, 'stg.jsonld'));
ok(-e catfile($output, 'zwi.jsonld'));

my $f = Mojo::File->new(catfile($output, 'lit.jsonld'));

my $coll = decode_json($f->slurp);

is($coll->{collection}->{operation},'operation:or');
is($coll->{collection}->{operands}->[0]->{'ref'},'bih');
is($coll->{collection}->{operands}->[-1]->{'ref'},'misc-lit');


$f = Mojo::File->new(catfile($output, 'N-gesamt.jsonld'));

$coll = decode_json($f->slurp);

is($coll->{collection}->{operation},'operation:and');
is($coll->{collection}->{operands}->[0]->{operands}->[0]->{'ref'},'bih');
is($coll->{collection}->{operands}->[-1]->{'ref'}, 'corp-w-gesamt.2023-i.16.03.23');
is($coll->{collection}->{operands}->[-1]->{'match'}, 'match:ne');




done_testing;
