/**
 * Shared morphological features configuration
 * Based on Universal Dependencies morphological features
 * Can be reused across different foundries (ud, spacy, etc.)
 */
define(function () {
  return {
    // Main morphological feature categories
    categories: [
      ["abbr","abbr:","abbreviation"],
      ["adptype","adptype:","adposition type"],
      ["animacy","animacy:","animacy"],
      ["aspect","aspect:","aspect"],
      ["case","case:","case"],
      ["conjtype","conjtype:","conjunction type"],
      ["definite","definite:","definiteness or state"],
      ["degree","degree:","degree"],
      ["foreign","foreign:","foreign word"],
      ["gender","gender:","gender"],
      ["hyph","hyph:","hyphenated compound or part of it"],
      ["mood","mood:","mood"],
      ["number","number:","number"],
      ["numtype","numtype:","numeral type"],
      ["parttype","parttype:","particle type"],
      ["person","person:","person"],
      ["polarity","polarity:","polarity"],
      ["poss","poss:","possessive"],
      ["prontype","prontype:","pronominal type"],
      ["puncttype","puncttype:","punctuation type"],
      ["reflex","reflex:","reflexive"],
      ["tense","tense:","tense"],
      ["typo","typo:","misspelled word"],
      ["variant","variant:","alternative form of word"],
      ["verbform","verbform:","form of verb or deverbative"],
      ["verbtype","verbtype:","verb type"]
    ],

    // Feature values for each category
    abbr: [
      ["yes","yes ","yes"]
    ],

    adptype: [
      ["circ","circ ","circumposition"],
      ["post","post ","postposition"],
      ["prep","prep ","preposition"],
      ["voc","voc ","vocalized preposition"]
    ],

    animacy: [
      ["anim","anim ","animate"],
      ["hum","hum ","human"],
      ["inan","inan ","inanimate"],
      ["nhum","nhum ","non-human"]
    ],

    aspect: [
      ["hab","hab ","habitual"],
      ["imp","imp ","imperfect"],
      ["iter","iter ","iterative / frequentative"],
      ["perf","perf ","perfect"],
      ["prog","prog ","progressive"],
      ["prosp","prosp ","prospective"]
    ],

    "case": [
      ["abe","abe ","abessive / caritative / privative"],
      ["abl","abl ","ablative / adelative"],
      ["abs","abs ","absolutive"],
      ["acc","acc ","accusative / oblique"],
      ["add","add ","additive"],
      ["ade","ade ","adessive"],
      ["all","all ","allative / adlative"],
      ["ben","ben ","benefactive / destinative"],
      ["cau","cau ","causative / motivative / purposive"],
      ["cmp","cmp ","comparative"],
      ["cns","cns ","considerative"],
      ["com","com ","comitative / associative"],
      ["dat","dat ","dative"],
      ["del","del ","delative / superelative"],
      ["dis","dis ","distributive"],
      ["ela","ela ","elative / inelative"],
      ["equ","equ ","equative"],
      ["erg","erg ","ergative"],
      ["ess","ess ","essive / prolative"],
      ["gen","gen ","genitive"],
      ["ill","ill ","illative / inlative"],
      ["ine","ine ","inessive"],
      ["ins","ins ","instrumental / instructive"],
      ["lat","lat ","lative / directional allative"],
      ["loc","loc ","locative"],
      ["nom","nom ","nominative / direct"],
      ["par","par ","partitive"],
      ["per","per ","perlative"],
      ["sbe","sbe ","subelative"],
      ["sbl","sbl ","sublative"],
      ["spl","spl ","superlative"],
      ["sub","sub ","subessive"],
      ["sup","sup ","superessive"],
      ["tem","tem ","temporal"],
      ["ter","ter ","terminative / terminal allative"],
      ["tra","tra ","translative / factive"],
      ["voc","voc ","vocative"]
    ],

    conjtype: [
      ["comp","comp ","comparing conjunction"],
      ["oper","oper ","mathematical operator"],
      ["pred","pred ","subordinating conjunction introducing a secondary predicate"]
    ],

    definite: [
      ["com","com ","complex"],
      ["cons","cons ","construct state / reduced definiteness"],
      ["def","def ","definite"],
      ["ind","ind ","indefinite"],
      ["spec","spec ","specific indefinite"]
    ],

    degree: [
      ["abs","abs ","absolute superlative"],
      ["aug","aug ","augmentative"],
      ["cmp","cmp ","comparative, second degree"],
      ["dim","dim ","diminutive"],
      ["equ","equ ","equative"],
      ["pos","pos ","positive, first degree"],
      ["sup","sup ","superlative, third degree"]
    ],

    foreign: [
      ["yes","yes ","yes"]
    ],

    gender: [
      ["com","com ","common"],
      ["fem","fem ","feminine",],
      ["masc","masc ","masculine"],
      ["neut","neut ","neuter"]
    ],

    hyph: [
      ["yes","yes ","yes"]
    ],

    mood: [
      ["adm","adm ","admirative"],
      ["cnd","cnd ","conditional"],
      ["des","des ","desiderative"],
      ["imp","imp ","imperative"],
      ["ind","ind ","indicative or realis"],
      ["int","int ","interrogative"],
      ["irr","irr ","irrealis"],
      ["jus","jus ","jussive / injunctive"],
      ["nec","nec ","necessitative"],
      ["opt","opt ","optative"],
      ["pot","pot ","potential"],
      ["prp","prp ","purposive"],
      ["qot","qot ","quotative"],
      ["sub","sub ","subjunctive / conjunctive"]
    ],

    number: [
      ["coll","coll ","collective / mass / singulare tantum"],
      ["count","count ","count plural"],
      ["dual","dual ","dual"],
      ["grpa","grpa ","greater paucal"],
      ["grpl","grpl ","greater plural"],
      ["inv","inv ","inverse"],
      ["pauc","pauc ","paucal"],
      ["plur","plur ","plural"],
      ["ptan","ptan ","plurale tantum"],
      ["sing","sing ","singular"],
      ["tri","tri ","trial"]
    ],

    numtype: [
      ["card","card ","cardinal number or corresponding interrogative / relative / indefinite / demonstrative word"],
      ["dist","dist ","distributive numeral"],
      ["frac","frac ","fraction"],
      ["mult","mult ","multiplicative numeral or corresponding interrogative / relative / indefinite / demonstrative word"],
      ["ord","ord ","ordinal number or corresponding interrogative / relative / indefinite / demonstrative word"],
      ["range","range ","range of values"],
      ["sets","sets ","number of sets of things; collective numeral"]
    ],

    parttype: [
      ["emp","emp ","particle of emphasis"],
      ["inf","inf ","infinitive marker"],
      ["int","int ","question particle"],
      ["mod","mod ","modal particle"],
      ["neg","neg ","negation particle"],
      ["res","res ","response particle"],
      ["vbp","vbp ","separated verb prefix in german"]
    ],

    person: [
      ["0","0 ","zero person"],
      ["1","1 ","first person"],
      ["2","2 ","second person"],
      ["3","3 ","third person"],
      ["4","4 ","fourth person"]
    ],

    polarity: [
      ["neg","neg ","negative"],
      ["pos","pos ","positive, affirmative"]
    ],

    poss: [
      ["yes","yes ","yes"]
    ],

    prontype: [
      ["art","art ","article"],
      ["dem","dem ","demonstrative pronoun, determiner, numeral or adverb"],
      ["emp","emp ","emphatic determiner"],
      ["exc","exc ","exclamative determiner"],
      ["ind","ind ","indefinite pronoun, determiner, numeral or adverb"],
      ["int","int ","interrogative pronoun, determiner, numeral or adverb"],
      ["neg","neg ","negative pronoun, determiner or adverb"],
      ["prs","prs ","personal or possessive personal pronoun or determiner"],
      ["rcp","rcp ","reciprocal pronoun"],
      ["rel","rel ","relative pronoun, determiner, numeral or adverb"],
      ["tot","tot ","total (collective) pronoun, determiner or adverb"]
    ],

    puncttype: [
      ["brck","brck ","bracket"],
      ["colo","colo ","colon"],
      ["comm","comm ","comma"],
      ["dash","dash ","dash, hyphen"],
      ["elip","elip ","ellipsis"],
      ["excl","excl ","exclamation mark"],
      ["peri","peri ","period at the end of sentence or clause"],
      ["qest","qest ","question mark"],
      ["quot","quot ","quotation marks"],
      ["semi","semi ","semicolon"],
      ["slsh","slsh ","slash or backslash"]
    ],

    reflex: [
      ["yes","yes ","yes"]
    ],

    tense: [
      ["fut","fut ","future tense"],
      ["imp","imp ","imperfect"],
      ["past","past ","past tense / preterite / aorist"],
      ["pqp","pqp ","pluperfect"],
      ["pres","pres ","present / non-past tense / aorist"]
    ],

    typo: [
      ["yes","yes ","yes"]
    ],

    variant: [
      ["short","short ","short form of adjectives"]
    ],

    verbform: [
      ["conv","conv ","converb, transgressive, adverbial participle, verbal adverb"],
      ["fin","fin ","finite verb"],
      ["gdv","gdv ","gerundive"],
      ["ger","ger ","gerund"],
      ["inf","inf ","infinitive"],
      ["part","part ","participle, verbal adjective"],
      ["sup","sup ","supine"],
      ["vnoun","vnoun ","verbal noun, masdar"]
    ],

    verbtype: [
      ["aux","aux ","auxiliary verb"],
      ["cop","cop ","copula verb"],
      ["light","light ","light (support) verb"],
      ["mod","mod ","modal verb"],
      ["quasi","quasi ","quasi-verb"]
    ]
  };
});
