/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.tokenizer;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.Span;

public interface KorapTokenizer
extends Tokenizer,
SentenceDetector {
    public void scan() throws IOException;

    public CharSequence[] getTargetLanguages();

    public void setInputReader(Reader var1);

    public void setSplitSentences(boolean var1);

    public void setEcho(boolean var1);

    public void setPrintOffsets(boolean var1);

    public void setPrintTokens(boolean var1);

    public void setOutputStream(PrintStream var1);

    public void setNormalize(boolean var1);

    @Override
    public String[] tokenize(String var1);

    @Override
    public Span[] tokenizePos(String var1);

    public String[] sentDetect(String var1);

    public Span[] sentPosDetect(String var1);

    public static class Builder {
        private boolean splitSentences;
        private boolean echo;
        private boolean printOffsets;
        private boolean printTokens;
        private PrintStream outputStream = System.out;
        private boolean normalize;
        private Class tokenizerClass;
        private Reader inputReader;

        public Builder tokenizerClassName(String tokenizerClassName) throws ClassNotFoundException {
            this.tokenizerClass = Class.forName(tokenizerClassName);
            return this;
        }

        public Builder splitSentences(boolean splitSentences) {
            this.splitSentences = splitSentences;
            return this;
        }

        public Builder setEcho(boolean echo) {
            this.echo = echo;
            return this;
        }

        public Builder printOffsets(boolean printOffsets) {
            this.printOffsets = printOffsets;
            return this;
        }

        public Builder printTokens(boolean printTokens) {
            this.printTokens = printTokens;
            return this;
        }

        public Builder inputReader(Reader inputReader) {
            this.inputReader = inputReader;
            return this;
        }

        public Builder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder outputStream(PrintStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public KorapTokenizer build() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            KorapTokenizer korapTokenizer = (KorapTokenizer)this.tokenizerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            korapTokenizer.setEcho(this.echo);
            korapTokenizer.setInputReader(this.inputReader);
            korapTokenizer.setOutputStream(this.outputStream);
            korapTokenizer.setNormalize(this.normalize);
            korapTokenizer.setPrintOffsets(this.printOffsets);
            korapTokenizer.setSplitSentences(this.splitSentences);
            korapTokenizer.setPrintTokens(this.printTokens);
            return korapTokenizer;
        }
    }
}

