package de.ids_mannheim.korap.oauth2.entity;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Set;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;

import lombok.Getter;
import lombok.Setter;

/**
 * Defines oauth2_access_token database table mapping and access token
 * relations to AccessScope and RefreshToken.
 * 
 * @author margaretha
 *
 */
@Getter
@Setter
@Entity
@Table(name = "oauth2_access_token")
public class AccessToken implements Serializable {

    private static final long serialVersionUID = 8452701765986475302L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private int id;
    private String token;
    @Column(name = "created_date", updatable = false)
    private ZonedDateTime createdDate;
    @Column(name = "expiry_date", updatable = false)
    private ZonedDateTime expiryDate;
    @Column(name = "user_id")
    private String userId;
    //    @Column(name = "client_id")
    //    private String clientId;
    @Column(name = "is_revoked")
    private boolean isRevoked;
    @Column(name = "user_auth_time", updatable = false)
    private ZonedDateTime userAuthenticationTime;

    // @OneToOne(fetch=FetchType.LAZY, cascade=CascadeType.REMOVE)
    // @JoinColumn(name="authorization_id")
    // private Authorization authorization;

    @ManyToMany(fetch = FetchType.EAGER)
    @JoinTable(name = "oauth2_access_token_scope", joinColumns = @JoinColumn(name = "token_id", referencedColumnName = "id"), inverseJoinColumns = @JoinColumn(name = "scope_id", referencedColumnName = "id"), uniqueConstraints = @UniqueConstraint(columnNames = {
            "token_id", "scope_id" }))
    private Set<AccessScope> scopes;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "refresh_token")
    private RefreshToken refreshToken;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "client")
    private OAuth2Client client;
}
