define(["hint/foundries","hint/foundries/stts","hint/foundries/negranodes","hint/foundries/negraedges"],
       function (ah, sttsArray, negraNodesArray, negraEdgesArray) {

  ah["-"].push(
    ["CoreNLP", "corenlp/", "Constituency, Named Entities, Part-of-Speech"]
  );

  ah["corenlp/"] = [
    ["Constituency", "c="],
    ["Named Entity", "ne=" , "Combined"],
    ["Named Entity", "ne_dewac_175m_600=" , "ne_dewac_175m_600"],
    ["Named Entity", "ne_hgc_175m_600=",    "ne_hgc_175m_600"],
    ["Part-of-Speech", "p="]
  ];

  ah["corenlp/ne="] = [
	["I-LOC",  "I-LOC ",  "Location"],
	["I-MISC", "I-MISC ", "Miscellaneous"],
	["I-ORG",  "I-ORG ",  "Organization"],
	["I-PER",  "I-PER ",  "Person"]
  ];
  
  ah["corenlp/ne_dewac_175m_600="] = [
	["I-LOC",  "I-LOC ",  "Location"],
	["I-MISC", "I-MISC ", "Miscellaneous"],
	["I-ORG",  "I-ORG ",  "Organization"],
	["I-PER",  "I-PER ",  "Person"]
  ];
	  
  ah["corenlp/ne_hgc_175m_600="] = [
	["I-LOC",  "I-LOC ",  "Location"],
	["I-MISC", "I-MISC ", "Miscellaneous"],
	["I-ORG",  "I-ORG ",  "Organization"],
	["I-PER",  "I-PER ",  "Person"]
  ];
	  
  ah["corenlp/p="] = [
    ["ADJA","ADJA ", "Attributive Adjective"],
    ["ADJD","ADJD ", "Predicative Adjective"],
    ["ADV","ADV ", "Adverb"],
    ["APPO","APPO ", "Postposition"],
    ["APPR","APPR ", "Preposition"],
    ["APPRART","APPRART ", "Preposition with Determiner"],
    ["APZR","APZR ","Right Circumposition"],
    ["ART","ART ", "Determiner"],
    ["CARD","CARD ", "Cardinal Number"],
    ["FM","FM ", "Foreign Material"],
    ["ITJ","ITJ ", "Interjection"],
    ["KOKOM","KOKOM ", "Comparison Particle"],
    ["KON","KON ", "Coordinating Conjuncion"],
    ["KOUI","KOUI ", "Subordinating Conjunction with 'zu'"],
    ["KOUS","KOUS ", "Subordinating Conjunction with Sentence"],
    ["NE","NE ", "Named Entity"],
    ["NN","NN ", "Normal Nomina"],
    ["PAV", "PAV ", "Pronominal Adverb"],
    ["PDAT","PDAT ","Attributive Demonstrative Pronoun"],
    ["PDS","PDS ", "Substitutive Demonstrative Pronoun"],
    ["PIAT","PIAT ", "Attributive Indefinite Pronoun without Determiner"],
    ["PIDAT","PIDAT ", "Attributive Indefinite Pronoun with Determiner"],
    ["PIS","PIS ", "Substitutive Indefinite Pronoun"],
    ["PPER","PPER ", "Personal Pronoun"],
    ["PPOSAT","PPOSAT ", "Attributive Possessive Pronoun"],
    ["PPOSS","PPOSS ", "Substitutive Possessive Pronoun"],
    ["PRELAT","PRELAT ", "Attributive Relative Pronoun"],
    ["PRELS","PRELS ", "Substitutive Relative Pronoun"],
    ["PRF","PRF ", "Reflexive Pronoun"],
    ["PROAV","PROAV ", "Pronominal Adverb"],
    ["PTKA","PTKA ","Particle with Adjective"],
    ["PTKANT","PTKANT ", "Answering Particle"],
    ["PTKNEG","PTKNEG ", "Negation Particle"],
    ["PTKVZ","PTKVZ ", "Separated Verbal Particle"],
    ["PTKZU","PTKZU ", "'zu' Particle"],
    ["PWAT","PWAT ", "Attributive Interrogative Pronoun"],
    ["PWAV","PWAV ", "Adverbial Interrogative Pronoun"],
    ["PWS","PWS ", "Substitutive Interrogative Pronoun"],
    ["TRUNC","TRUNC ","Truncated"],
    ["VAFIN","VAFIN ", "Auxiliary Finite Verb"],
    ["VAIMP","VAIMP ", "Auxiliary Finite Imperative Verb"],
    ["VAINF","VAINF ", "Auxiliary Infinite Verb"],
    ["VAPP","VAPP ", "Auxiliary Perfect Participle"],
    ["VMFIN","VMFIN ", "Modal Finite Verb"],
    ["VMINF","VMINF ", "Modal Infinite Verb"],
    ["VMPP","VMPP ", "Modal Perfect Participle"],
    ["VVFIN","VVFIN ","Finite Verb"],
    ["VVIMP","VVIMP ", "Finite Imperative Verb"],
    ["VVINF","VVINF ", "Infinite Verb"],
    ["VVIZU","VVIZU ", "Infinite Verb with 'zu'"],
    ["VVPP","VVPP ", "Perfect Participle"],
    ["XY", "XY ", "Non-Word"]
  ];
  
  ah["corenlp/c="] = [
    ["AA", "AA", "superlative phrase with 'am'"],
    ["AP","AP", "adjektive phrase"],
    ["AVP","AVP", "adverbial phrase"],
    ["CAP","CAP", "coordinated adjektive phrase"],
    ["CAVP","CAVP", "coordinated adverbial phrase"],
    ["CAC","CAC", "coordinated adposition"],
    ["CCP","CCP", "coordinated complementiser"],
    ["CH","CH", "chunk"],
    ["CNP","CNP", "coordinated noun phrase"],
    ["CO","CO", "coordination"],
    ["CPP","CPP", "coordinated adpositional phrase"],
    ["CS","CS", "coordinated sentence"],
    ["CVP","CVP", "coordinated verb phrase (non-finite)"],
    ["CVZ","CVZ", "coordinated zu-marked infinitive"],
    ["DL","DL", "discourse level constituent"],
    ["ISU","ISU", "idiosyncratis unit"],
    ["MPN","MPN", "multi-word proper noun"],
    ["MTA","MTA", "multi-token adjective"],
    ["NM","NM", "multi-token number"],
    ["NP","NP", "noun phrase"],
    ["PP","PP", "adpositional phrase"],
    ["QL","QL", "quasi-languag"],
    ["ROOT","ROOT", "root node"],
    ["S","S", "sentence"],
    ["VP","VP", "verb phrase (non-finite)"],
    ["VZ","VZ", "zu-marked infinitive"]
  ];
  
  ah["corenlp/c=AA-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=AP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=AVP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CAP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CAVP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CAC-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CCP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CH-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CNP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CO-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CPP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CS-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CVP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=CVZ-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=DL-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=ISU-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=MPN-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=MTA-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=NM-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=NP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=PP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=QL-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=ROOT-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=S-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=VP-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];

	ah["corenlp/c=VZ-"] = [
	  ["AC", "AC ", "adpositional case marker"],
	  ["ADC", "ADC ", "adjective component"],
	  ["AMS", "AMS ", "measure argument of adj"],
	  ["APP", "APP ", "apposition"],
	  ["AVC", "AVC ", "adverbial phrase component"],
	  ["CC", "CC ", "comparative complement"],
	  ["CD", "CD ", "coordinating conjunction"],
	  ["CJ", "CJ ", "conjunct"],
	  ["CM", "CM ", "comparative concjunction"],
	  ["CP", "CP ", "complementizer"],
	  ["DA", "DA ", "dative"],
	  ["DH", "DH ", "discourse-level head"],
	  ["DM", "DM ", "discourse marker"],
	  ["GL", "GL ", "prenominal genitive"],
	  ["GR", "GR ", "postnominal genitive"],
	  ["HD", "HD ", "head"],
	  ["JU", "JU ", "junctor"],
	  ["MC", "MC ", "comitative"],
	  ["MI", "MI ", "instrumental"],
	  ["ML", "ML ", "locative"],
	  ["MNR", "MNR ", "postnominal modifier"],
	  ["MO", "MO ", "modifier"],
	  ["MR", "MR ", "rhetorical modifier"],
	  ["MW", "MW ", "way (directional modifier)"],
	  ["NG", "NG ", "negation"],
	  ["NK", "NK ", "noun kernel modifier"],
	  ["NMC", "NMC ", "numerical component"],
	  ["OA", "OA ", "accusative object"],
	  ["OA2", "OA2 ", "second accusative object"],
	  ["OC", "OC ", "clausal object"],
	  ["OG", "OG ", "genitive object"],
	  ["PD", "PD ", "predicate"],
	  ["PG", "PG ", "pseudo-genitive"],
	  ["PH", "PH ", "placeholder"],
	  ["PM", "PM ", "morphological particle"],
	  ["PNC", "PNC ", "proper noun component"],
	  ["RC", "RC ", "relative clause"],
	  ["RE", "RE ", "repeated element"],
	  ["RS", "RS ", "reported speech"],
	  ["SB", "SB ", "subject"],
	  ["SBP", "SBP ", "passivised subject (PP)"],
	  ["SP", "SP ", "subject or predicate"],
	  ["SVP", "SVP ", "separable verb prefix"],
	  ["UC", "UC ", "(idiosyncratic) unit component"],
	  ["VO", "VO ", "vocative"]
	];


  
//  for (var i in negraNodesArray) {
//    ah["corenlp/c=" + negraNodesArray[i][0] + '-'] = negraEdgesArray;
//  };
});
