% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPQuery.R
\name{corpusQuery,KorAPConnection-method}
\alias{corpusQuery,KorAPConnection-method}
\alias{corpusQuery}
\title{Search corpus for query terms}
\usage{
\S4method{corpusQuery}{KorAPConnection}(
  kco,
  query = if (missing(KorAPUrl)) {
    
    stop("At least one of the parameters query and KorAPUrl must be specified.", call. =
    FALSE)
 } else {
     httr2::url_parse(KorAPUrl)$query$q
 },
  vc = if (missing(KorAPUrl)) "" else httr2::url_parse(KorAPUrl)$query$cq,
  KorAPUrl,
  metadataOnly = TRUE,
  ql = if (missing(KorAPUrl)) "poliqarp" else httr2::url_parse(KorAPUrl)$query$ql,
  fields = c("corpusSigle", "textSigle", "pubDate", "pubPlace", "availability",
    "textClass", "snippet", "tokens"),
  accessRewriteFatal = TRUE,
  verbose = kco@verbose,
  expand = length(vc) != length(query),
  as.df = FALSE,
  context = NULL
)
}
\arguments{
\item{kco}{\code{\link[=KorAPConnection]{KorAPConnection()}} object (obtained e.g. from \code{KorAPConnection()}}

\item{query}{string that contains the corpus query. The query language depends on the \code{ql} parameter. Either \code{query} must be provided or \code{KorAPUrl}.}

\item{vc}{string describing the virtual corpus in which the query should be performed. An empty string (default) means the whole corpus, as far as it is license-wise accessible.}

\item{KorAPUrl}{instead of providing the query and vc string parameters, you can also simply copy a KorAP query URL from your browser and use it here (and in \code{KorAPConnection}) to provide all necessary information for the query.}

\item{metadataOnly}{logical that determines whether queries should return only metadata without any snippets. This can also be useful to prevent access rewrites. Note that the default value is TRUE.
If you want your corpus queries to return not only metadata, but also KWICS, you need to authorize
your RKorAPClient application as explained in the
\href{https://github.com/KorAP/RKorAPClient#authorization}{authorization section}
of the RKorAPClient Readme on GitHub and set the \code{metadataOnly} parameter to
\code{FALSE}.}

\item{ql}{string to choose the query language (see \href{https://github.com/KorAP/Kustvakt/wiki/Service:-Search-GET#user-content-parameters}{section on Query Parameters} in the Kustvakt-Wiki for possible values.}

\item{fields}{character vector specifying which metadata fields to retrieve for each match.
Available fields depend on the corpus. For DeReKo (German Reference Corpus), possible fields include:
\describe{
\item{\strong{Text identification}:}{\code{textSigle}, \code{docSigle}, \code{corpusSigle} - hierarchical text identifiers}
\item{\strong{Publication info}:}{\code{author}, \code{editor}, \code{title}, \code{docTitle}, \code{corpusTitle} - authorship and titles}
\item{\strong{Temporal data}:}{\code{pubDate}, \code{creationDate} - when text was published/created}
\item{\strong{Publication details}:}{\code{pubPlace}, \code{publisher}, \code{reference} - where/how published}
\item{\strong{Text classification}:}{\code{textClass}, \code{textType}, \code{textTypeArt}, \code{textDomain}, \code{textColumn} - topic domain, genre, text type and column}
\item{\strong{Adminstrative and technical info}:}{\code{corpusEditor}, \code{availability}, \code{language}, \code{foundries} - access rights and annotations}
\item{\strong{Content data}:}{\code{snippet}, \code{tokens}, \code{tokenSource}, \code{externalLink} - actual text content, tokenization, and link to source text}
\item{\strong{System data}:}{\code{indexCreationDate}, \code{indexLastModified} - corpus indexing info}
}
Use \code{c("textSigle", "pubDate", "author")} to retrieve multiple fields.
Default fields provide basic text identification and publication metadata. The actual text content (\code{snippet} and \code{tokens}) are activated by default  if \code{metadataOnly} is set to \code{FALSE}.}

\item{accessRewriteFatal}{abort if query or given vc had to be rewritten due to insufficient rights (not yet implemented).}

\item{verbose}{print some info}

\item{expand}{logical that decides if \code{query} and \code{vc} parameters are expanded to all of their combinations. Defaults to \code{TRUE}, iff \code{query} and \code{vc} have different lengths}

\item{as.df}{return result as data frame instead of as S4 object?}

\item{context}{string that specifies the size of the left and the right context returned in \code{snippet}
(provided that \code{metadataOnly} is set to \code{false} and that the necessary access right are  met).
The format of the context size specifcation (e.g. \verb{3-token,3-token}) is described in the \href{https://github.com/KorAP/Kustvakt/wiki/Service:-Search-GET}{Service: Search GET documentation of the Kustvakt Wiki}.
If the parameter is not set, the default context size secification of the KorAP server instance will be used.
Note that you cannot overrule the maximum context size set in the KorAP server instance,
as this is typically legally motivated.}
}
\value{
Depending on the \code{as.df} parameter, a tibble or a \code{\link[=KorAPQuery]{KorAPQuery()}} object that, among other information, contains the total number of results in \verb{@totalResults}. The resulting object can be used to fetch all query results (with \code{\link[=fetchAll]{fetchAll()}}) or the next page of results (with \code{\link[=fetchNext]{fetchNext()}}).
A corresponding URL to be used within a web browser is contained in \verb{@webUIRequestUrl}
Please make sure to check \verb{$collection$rewrites} to see if any unforeseen access rewrites of the query's virtual corpus had to be performed.
}
\description{
\strong{\code{corpusQuery}} performs a corpus query via a connection to a KorAP-API-server
}
\examples{
\dontrun{

# Fetch basic metadata for "Ameisenplage"
KorAPConnection() |>
  corpusQuery("Ameisenplage") |>
  fetchAll()

# Fetch specific metadata fields for bibliographic analysis
query <- KorAPConnection() |>
  corpusQuery("Ameisenplage",
              fields = c("textSigle", "author", "title", "pubDate", "pubPlace", "textType"))
results <- fetchAll(query)
results@collectedMatches
}

\dontrun{

# Use the copy of a KorAP-web-frontend URL for an API query of "Ameise" in a virtual corpus
# and show the number of query hits (but don't fetch them).

KorAPConnection(verbose = TRUE) |>
  corpusQuery(
    KorAPUrl =
      "https://korap.ids-mannheim.de/?q=Ameise&cq=pubDate+since+2017&ql=poliqarp"
  )
}

\dontrun{

# Plot the time/frequency curve of "Ameisenplage"
KorAPConnection(verbose = TRUE) |>
  {
    . ->> kco
  } |>
  corpusQuery("Ameisenplage") |>
  fetchAll() |>
  slot("collectedMatches") |>
  mutate(year = lubridate::year(pubDate)) |>
  dplyr::select(year) |>
  group_by(year) |>
  summarise(Count = dplyr::n()) |>
  mutate(Freq = mapply(function(f, y) {
    f / corpusStats(kco, paste("pubDate in", y))@tokens
  }, Count, year)) |>
  dplyr::select(-Count) |>
  complete(year = min(year):max(year), fill = list(Freq = 0)) |>
  plot(type = "l")
}
}
\references{
\url{https://ids-pub.bsz-bw.de/frontdoor/index/index/docId/9026}
}
\seealso{
\code{\link[=KorAPConnection]{KorAPConnection()}}, \code{\link[=fetchNext]{fetchNext()}}, \code{\link[=fetchRest]{fetchRest()}}, \code{\link[=fetchAll]{fetchAll()}}, \code{\link[=corpusStats]{corpusStats()}}

Other corpus search functions: 
\code{\link{fetchAll,KorAPQuery-method}},
\code{\link{fetchAnnotations,KorAPQuery-method}},
\code{\link{fetchNext,KorAPQuery-method}}
}
\concept{corpus search functions}
