% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{calculate_sophisticated_eta}
\alias{calculate_sophisticated_eta}
\title{Calculate sophisticated ETA using median of recent non-cached times}
\usage{
calculate_sophisticated_eta(
  individual_times,
  current_item,
  total_items,
  cache_threshold = 0.1,
  window_size = 5
)
}
\arguments{
\item{individual_times}{numeric vector of individual item processing times}

\item{current_item}{current item number (1-based)}

\item{total_items}{total number of items to process}

\item{cache_threshold}{minimum time in seconds to consider as non-cached (default: 0.1)}

\item{window_size}{number of recent non-cached times to use for median calculation (default: 5)}
}
\value{
list with eta_seconds, estimated_completion_time, and is_cached flag
}
\description{
Advanced ETA calculation that excludes cached responses and uses median
of recent timing data for more stable estimates. This is particularly
useful for operations where some responses may be cached and much faster.
}
\keyword{internal}
