#!/usr/bin/env node
process.env.NTBA_FIX_319 = 1;
const { Command } = require('commander');
const Tgfancy = require("tgfancy");
const { exec } = require("child_process");
const sleep = require('sleep');
const program = new Command();

program
    .arguments('<path-of-folder>')
    .description( 'Sends telegram message when there are no modifications to <path-of-folder> since a certain time interval.')
    .option('-d, --debug', 'output extra debugging')
    .option('-s, --seconds <int>', 'notify if no changes since n seconds', 120)
    .option('-p, --poll-interval <int>', 'interval in seconds between polls', 30)
    .parse(process.argv);

const options = program.opts();
if (options.debug) console.log(options);

function timeString() {
    return "[" + (new Date()).toISOString() + "]"
}

function waitUntilIdle(filePath, seconds = options.seconds, pollInterval = options.pollInterval, cb = sendTelegramMessage) {
    exec(`find ${filePath} -maxdepth 1 -newermt '-${seconds} seconds'`, (error, stdout, stderr) => {
        if (error) {
            const message = `error: ${error.message}`
            console.log(message);
            cb(message);
            return;
        }
        if (stderr) {
            const message = `stderr: ${stderr}`
            console.log(message);
            cb(message);
            return;
        }
        if (stdout.length == 0) {
            const message = `No modifications in ${filePath} since ${seconds} seconds`
            console.log(`${timeString()}: ${message}`)
            cb(message);
        } else {
            var message = `${timeString()}: still processing ${stdout.trim()}`;
            console.log(message);
            sleep.sleep(pollInterval);
            waitUntilIdle(filePath, seconds, pollInterval, cb)
        }
    });
}

function sendTelegramMessage(message, bot = new Tgfancy(process.env.TELEGRAM_TOKEN), chatId = process.env.TELEGRAM_CHAT_ID) {
    bot.sendMessage(chatId, message);
}

waitUntilIdle(program.args[0]);
