#!/usr/bin/env node
const { WebClient } = require('@slack/web-api');
const { Command } = require('commander');
const fs = require('fs');
const program = new Command();
var stdin = "";

// An access token (from your Slack app or custom integration - xoxp, xoxb)
const token = process.env.SLACK_TOKEN;
const web = new WebClient(token);

program
    .arguments('[message]')
    .description('Sends <message> to a slack channel. Use - for reading message from stdin')
    .option('-d, --debug', 'output extra debugging')
    .option('-c, --channel <channel_id>', 'send message to slack channel', "dereko")
    .parse(process.argv)
    .action(function (message) {
        if (stdin) message = stdin;

        (async () => {
            // See: https://api.slack.com/methods/chat.postMessage
            const res = await web.chat.postMessage({ channel: options.channel, text: message });
            // `res` contains information about the posted message
            console.log('Message sent: ', res.ts);
        })();
    })

const options = program.opts();
if (options.debug) console.log(options);

if (program.args.length == 0 || program.args[0] == '-') {
    console.debug("Reading from stdin")
    stdin = '```\n' + fs.readFileSync(0, 'utf-8') + '```';
}

program.parse(process.argv);
