Assorted KorAP related Tools and Helpers

## Index of tools

* [Import (cherry-pick) pull requests from github](Import pull requests from github)
* [Count commits in repositories](Count commits in repositories)

## Import pull requests from github

### Synopsis

Cherry pick all PRs from github (that pass your gh action PR workflow, if you have one). 

### Description

This tool browses through the github pull requests concerning the project referred to by the
`github` git remote of your current working directory and cherry picks all of them – 
or, in case there is a github action workflow, all those that pass their latest workflow.

In addition to picking the PR's commits the tool also prints out (outcommented) 
bash commands that you can use to copy and paste them in your shell to:

* push the picks to the KorAP gerrit for review
* and to review the picks automatically with `+1`

### Usage

```shell
Usage: sh import_github_pull_requests [-h] [-v] [-f]
        -f   import PRs with **failed** CI tests
```

### Dependencies

* jq - commandline JSON processor
    * `apt install jq`
    * `dnf install jq`

Ideally you should also have a personal github access token (see [docuumentation](https://docs.github.com/en/free-pro-team@latest/github/authenticating-to-github/creating-a-personal-access-token) how to create one) and store it in the environment variable
`GITHUB_KORAP_REPO_AUTH` like in this example:

```shell
export GITHUB_KORAP_REPO_AUTH="-u janedoe:53bd435ed3e456548ec2d1a94172591cc0ae1167"
```

### Example

```shell
$ cd Kustvakt/
$ ../Tools/bin/import_github_pull_requests
```

If you experience limited API access, create a personal github access token (s. Dependencies).

The Output should be similar to:

```shell
remote: Enumerating objects: 16, done.
remote: Counting objects: 100% (16/16), done.
remote: Compressing objects: 100% (12/12), done.
remote: Total 39 (delta 9), reused 4 (delta 4), pack-reused 23
Entpacke Objekte: 100% (39/39), 13.58 KiB | 926.00 KiB/s, Fertig.
Von https://github.com/KorAP/Kustvakt
 * [neuer Branch]      add-dependabot-action                                   -> github/add-dependabot-action
 * [neuer Branch]      dependabot/maven/core/hibernate.version-5.4.24.Final    -> github/dependabot/maven/core/hibernate.version-5.4.24.Final
 * [neuer Branch]      dependabot/maven/core/log4j.version-2.14.0              -> github/dependabot/maven/core/log4j.version-2.14.0
 * [neuer Branch]      dependabot/maven/core/org.flywaydb-flyway-core-6.5.1    -> github/dependabot/maven/core/org.flywaydb-flyway-core-6.5.1
 * [neuer Branch]      dependabot/maven/core/spring.version-5.3.1              -> github/dependabot/maven/core/spring.version-5.3.1
 * [neuer Branch]      dependabot/maven/full/com.nimbusds-oauth2-oidc-sdk-8.26 -> github/dependabot/maven/full/com.nimbusds-oauth2-oidc-sdk-8.26
 * [neuer Branch]      dependabot/maven/full/hibernate.version-5.4.24.Final    -> github/dependabot/maven/full/hibernate.version-5.4.24.Final
 * [neuer Branch]      dev                                                     -> github/dev
   bdd47ac4..f4fa1eb6  master                                                  -> github/master
 * [neuer Branch]      openid                                                  -> github/openid
[master 3619527c] Bump hibernate.version from 5.4.23.Final to 5.4.24.Final in /full
 Author: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>
 Date: Wed Nov 18 05:44:31 2020 +0000
 1 file changed, 1 insertion(+), 1 deletion(-)
[master df7147bb] Bump hibernate.version from 5.4.20.Final to 5.4.24.Final in /core
 Author: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>
 Date: Wed Nov 18 05:44:07 2020 +0000
 1 file changed, 1 insertion(+), 1 deletion(-)
[master 87dab806] Bump oauth2-oidc-sdk from 8.25 to 8.26 in /full
 Author: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>
 Date: Mon Nov 16 06:20:36 2020 +0000
 1 file changed, 1 insertion(+), 1 deletion(-)
[master 75b23c16] Bump spring.version from 5.3.0 to 5.3.1 in /core
 Author: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>
 Date: Wed Nov 11 05:45:14 2020 +0000
 1 file changed, 1 insertion(+), 1 deletion(-)

New pull requests:
* 75b23c16 (Bump spring.version from 5.3.0 to 5.3.1 in /core, 2020-11-11)
* 87dab806 (Bump oauth2-oidc-sdk from 8.25 to 8.26 in /full, 2020-11-16)
* df7147bb (Bump hibernate.version from 5.4.20.Final to 5.4.24.Final in /core, 2020-11-18)
* 3619527c (Bump hibernate.version from 5.4.23.Final to 5.4.24.Final in /full, 2020-11-18)

# Copy and paste for code review:
#
# git push origin HEAD:refs/for/master
#
# ssh -p 29418 korap gerrit review --code-review +1 $(git rev-list f4fa1eb65586dd0f96ea1cc8efb71223f8667e9f..HEAD)
```

## Count commits in repositories

Script to count all commits in various repositories for reporting.

More information using ...

```shell
$ perldoc count_commits
```
