const { execSync } = require('child_process');
const exp = require('constants');

describe('conllu2cmc', () => {
  test('Test sparse mode', (done) => {
    // Modify the command based on your script's location and options
    const command = 'node src/index.js -s < test/data/ndy.conllu';
    const stdout = execSync(command).toString();
    expect(stdout).toContain('😂\t_\tEMOIMG\tEMOIMG');
    var emoimg_count = (stdout.match(/EMOIMG/g) || []).length;
    expect(emoimg_count).toBe(382);
    var ascimg_count = (stdout.match(/EMOASC/g) || []).length;
    expect(ascimg_count).toBe(60);
    var ascimg_count = (stdout.match(/URL/g) || []).length;
    expect(ascimg_count).toBe(8);
    var adr_count = (stdout.match(/ADR/g) || []).length;
    expect(adr_count).toBe(2);
    var lines_count = (stdout.split("\n")).length;
    expect(lines_count).toBe(744);
    done();
  });

  test('Test full mode', (done) => {
    const command = 'node src/index.js < test/data/ndy.conllu';
    const stdout = execSync(command).toString();
      expect(stdout).toContain('😂\t_\tEMOIMG\tEMOIMG');
      var emoimg_count = (stdout.match(/EMOIMG/g) || []).length;
      expect(emoimg_count).toBe(382);
      var ascimg_count = (stdout.match(/EMOASC/g) || []).length;
      expect(ascimg_count).toBe(60);
      var ascimg_count = (stdout.match(/URL/g) || []).length;
      expect(ascimg_count).toBe(8);
      var adr_count = (stdout.match(/ADR/g) || []).length;
      expect(adr_count).toBe(2);
      var lines_count = (stdout.split("\n")).length;
      expect(lines_count).toBe(6200);
      done();
  });
});
