# conllu-cmc

[![Docker](https://img.shields.io/docker/v/korap/conllu-cmc?label=Docker&sort=semver)](https://hub.docker.com/r/korap/conllu-cmc)

Reads CoNLL-U format from stdin and annotates emojis, emoticons, hashtags, URLs, email addresses, action words, @names, and Wikipedia emoji templates with their corresponding STTS-IBK POS tag (Beißwenger/Bartsch/Evert/Würzner 2016). Writes CoNLL-U format to stdout.

## Docker Usage

```shell
# Annotate CoNLL-U input
korapxml2conllu kyc.zip | docker run --rm -i korap/conllu-cmc

# With sparse output (only annotated lines)
korapxml2conllu kyc.zip | docker run --rm -i korap/conllu-cmc -s

# Generate KorAP-XML zip with CMC annotations
korapxml2conllu kyc.zip | docker run --rm -i korap/conllu-cmc -s | conllu2korapxml > kyc.cmc.zip

# Show help
docker run --rm korap/conllu-cmc --help
```

## Local Usage

```shell
korapxml2conllu kyc.zip | conllu-cmc
```

### Generate KorAP-XML zip with CMC annotations

```shell
korapxml2conllu kyc.zip | conllu-cmc -s | conllu2korapxml > kyc.cmc.zip
```

## Installation

### Docker (recommended)

```shell
docker pull korap/conllu-cmc
```

### npm

```shell
npm install 'git+https://gitlab.ids-mannheim.de/KorAP/conllu-cmc-docker.git'
```

### Build from source

```shell
npm install
```

#### Build standalone

```shell
npm run pkg-linux
```

## References

Beißwenger, Michael/Bartsch, Sabine/Evert, Stefan/Würzner, Kay-Michael (2016): EmpiriST 2015: A Shared Task on the Automatic Linguistic Annotation of Computer-Mediated Communication and Web Corpora. In: Proceedings of the 10th Web as Corpus Workshop. Berlin: Association for Computational Linguistics, S. 44–56. https://doi.org/10.18653/v1/W16-2606.
