/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanExpansionQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandedSpans
extends SimpleSpans {
    private int min;
    private int max;
    private byte classNumber;
    private int direction;
    private List<CandidateSpan> candidateSpans;
    private long matchCost;
    private final Logger log = LoggerFactory.getLogger(ExpandedSpans.class);
    public static final boolean DEBUG = false;

    public ExpandedSpans(SpanExpansionQuery spanExpansionQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanExpansionQuery, context, acceptDocs, termContexts);
        this.min = spanExpansionQuery.getMin();
        this.max = spanExpansionQuery.getMax();
        this.direction = spanExpansionQuery.getDirection();
        this.classNumber = spanExpansionQuery.getClassNumber();
        this.candidateSpans = new ArrayList<CandidateSpan>();
        this.hasMoreSpans = this.firstSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    private boolean advance() throws IOException {
        while (this.candidateSpans.size() > 0 || this.hasMoreSpans) {
            if (this.candidateSpans.size() > 0) {
                CandidateSpan cs = this.candidateSpans.get(0);
                this.setMatch(cs);
                this.candidateSpans.remove(cs);
                return true;
            }
            this.setCandidateList();
            Collections.sort(this.candidateSpans);
        }
        return false;
    }

    private void setCandidateList() throws IOException {
        int end = 0;
        if (this.direction < 0) {
            int start;
            for (int counter = this.max; counter >= this.min; --counter) {
                start = this.firstSpans.start() - counter;
                if (start < 0) continue;
                CandidateSpan cs = new CandidateSpan(start, this.firstSpans.end(), this.firstSpans.doc(), this.firstSpans.cost(), this.createPayloads(start, this.firstSpans.start()));
                this.candidateSpans.add(cs);
            }
            int lastPosition = this.firstSpans.start();
            if (this.hasMoreSpans && (this.hasMoreSpans = this.firstSpans.next()) && (start = Math.max(0, this.firstSpans.start() - this.max)) <= lastPosition) {
                this.setCandidateList();
            }
        } else {
            for (int counter = this.min; counter <= this.max; ++counter) {
                end = this.firstSpans.end() + counter;
                CandidateSpan cs = new CandidateSpan(this.firstSpans.start(), end, this.firstSpans.doc(), this.firstSpans.cost(), this.createPayloads(this.firstSpans.end(), end));
                this.candidateSpans.add(cs);
            }
            int lastPosition = end;
            if (this.hasMoreSpans && (this.hasMoreSpans = this.firstSpans.next()) && this.firstSpans.start() <= lastPosition) {
                this.setCandidateList();
            }
        }
    }

    private ArrayList<byte[]> createPayloads(int start, int end) throws IOException {
        ArrayList<byte[]> payload = new ArrayList<byte[]>();
        if (this.firstSpans.isPayloadAvailable()) {
            payload.addAll(this.firstSpans.getPayload());
        }
        if (this.classNumber > 0) {
            payload.add(this.createExtensionPayloads(start, end));
        }
        return payload;
    }

    private byte[] createExtensionPayloads(int start, int end) {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        Byte classPTI = 0;
        buffer.put(classPTI);
        buffer.putInt(start);
        buffer.putInt(end);
        buffer.put(this.classNumber);
        return buffer.array();
    }

    private void setMatch(CandidateSpan candidateSpan) {
        this.matchDocNumber = candidateSpan.getDoc();
        this.matchStartPosition = candidateSpan.getStart();
        this.matchEndPosition = candidateSpan.getEnd();
        this.matchPayload = candidateSpan.getPayloads();
        this.matchCost = candidateSpan.getCost();
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        this.matchPayload.clear();
        return this.advance();
    }

    @Override
    public long cost() {
        return this.matchCost;
    }
}

