/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.toutanova;

import java.util.Iterator;
import java.util.List;
import lemming.lemma.toutanova.ToutanovaModel;
import marmot.util.HashableIntArray;

public class Result
implements Comparable<Result> {
    private List<Integer> outputs_;
    private List<Integer> inputs_;
    private ToutanovaModel model_;
    private double score_;
    private String form_;
    private HashableIntArray signature_;

    public Result(ToutanovaModel model, List<Integer> outputs, List<Integer> inputs, String form, double score) {
        this.model_ = model;
        this.outputs_ = outputs;
        this.inputs_ = inputs;
        this.score_ = score;
        this.form_ = form;
    }

    public Result(ToutanovaModel model, List<Integer> outputs, List<Integer> inputs, String form) {
        this(model, outputs, inputs, form, Double.NEGATIVE_INFINITY);
    }

    public String getOutput() {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> output_iterator = this.outputs_.iterator();
        Iterator<Integer> input_iterator = this.inputs_.iterator();
        Integer input_start_index = 0;
        while (output_iterator.hasNext()) {
            assert (input_iterator.hasNext());
            Integer output_index = output_iterator.next();
            Integer input_end_index = input_iterator.next();
            String output_segment = output_index == 0 ? this.form_.substring(input_start_index, input_end_index) : this.model_.getOutput(output_index);
            sb.append(output_segment);
            input_start_index = input_end_index;
        }
        assert (!input_iterator.hasNext());
        return sb.toString();
    }

    public List<Integer> getOutputs() {
        return this.outputs_;
    }

    public List<Integer> getInputs() {
        return this.inputs_;
    }

    public double getScore() {
        return this.score_;
    }

    @Override
    public int compareTo(Result result) {
        return -Double.compare(this.score_, result.score_);
    }

    public Result setSignature(HashableIntArray signature) {
        this.signature_ = signature;
        return this;
    }

    public HashableIntArray getSignature() {
        return this.signature_;
    }
}

