/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marmot.core.Sequence;
import marmot.core.Token;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;
import marmot.util.Mutable;

public class LemmaInstance {
    private double count_ = 1.0;
    private String form_;
    private String lemma_;
    private String ptag_;
    private String mtag_;

    public String toString() {
        String ptag = "_";
        if (this.ptag_ != null) {
            ptag = this.ptag_;
        }
        String mtag = "_";
        if (this.mtag_ != null) {
            mtag = this.mtag_;
        }
        return String.format("%s\t%s\t%s\t%s", this.form_, ptag, mtag, this.lemma_);
    }

    public LemmaInstance(String form, String lemma, String tag, String mtag) {
        this.form_ = form;
        this.lemma_ = lemma;
        this.ptag_ = tag;
        this.mtag_ = mtag;
    }

    public String getForm() {
        return this.form_;
    }

    public String getLemma() {
        return this.lemma_;
    }

    public String getFormPadded() {
        return "123" + this.form_ + "456";
    }

    public String getLemmaPadded() {
        return this.lemma_;
    }

    public String getPosTag() {
        return this.ptag_;
    }

    public void setCount(double count2) {
        this.count_ = count2;
    }

    public double getCount() {
        return this.count_;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.form_ == null ? 0 : this.form_.hashCode());
        result = 31 * result + (this.lemma_ == null ? 0 : this.lemma_.hashCode());
        result = 31 * result + (this.mtag_ == null ? 0 : this.mtag_.hashCode());
        result = 31 * result + (this.ptag_ == null ? 0 : this.ptag_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LemmaInstance other = (LemmaInstance)obj;
        if (this.form_ == null ? other.form_ != null : !this.form_.equals(other.form_)) {
            return false;
        }
        if (this.lemma_ == null ? other.lemma_ != null : !this.lemma_.equals(other.lemma_)) {
            return false;
        }
        if (this.mtag_ == null ? other.mtag_ != null : !this.mtag_.equals(other.mtag_)) {
            return false;
        }
        return !(this.ptag_ == null ? other.ptag_ != null : !this.ptag_.equals(other.ptag_));
    }

    public static List<LemmaInstance> getInstances(Iterable<Sequence> reader) {
        return LemmaInstance.getInstances(reader, -1);
    }

    public static List<LemmaInstance> getInstances(Iterable<Sequence> reader, int limit) {
        return LemmaInstance.getInstances(reader, limit, true, true);
    }

    public static List<LemmaInstance> getInstances(Iterable<Sequence> reader, boolean use_ptag, boolean use_mtag) {
        return LemmaInstance.getInstances(reader, -1, use_ptag, use_mtag);
    }

    public static List<LemmaInstance> getInstances(Iterable<Sequence> reader, int limit, boolean use_postag, boolean use_mtag) {
        HashMap<LemmaInstance, Mutable> map2 = new HashMap<LemmaInstance, Mutable>();
        int number = 0;
        for (Sequence sentence : reader) {
            for (Token token : sentence) {
                ++number;
                LemmaInstance instance = LemmaInstance.getInstance((Word)token, use_postag, use_mtag);
                Mutable mi = map2.computeIfAbsent(instance, k -> new Mutable<Integer>(0));
                mi.set((Integer)mi.get() + 1);
            }
            if (limit < 0 || number <= limit) continue;
            break;
        }
        LinkedList<LemmaInstance> instances = new LinkedList<LemmaInstance>();
        for (Map.Entry entry : map2.entrySet()) {
            LemmaInstance instance = (LemmaInstance)entry.getKey();
            double count2 = ((Integer)((Mutable)entry.getValue()).get()).intValue();
            instance.setCount(count2);
            instances.add(instance);
        }
        return instances;
    }

    public static List<LemmaInstance> getInstances(String file) {
        return LemmaInstance.getInstances(new SentenceReader(file));
    }

    public String getMorphTag() {
        return this.mtag_;
    }

    public static LemmaInstance getInstance(Word word, boolean use_postag, boolean use_mtag) {
        String form = word.getWordForm();
        if (form == null) {
            throw new RuntimeException("Form is null. Did you specify a form-index?");
        }
        form = form.toLowerCase();
        String lemma = word.getLemma();
        if (lemma != null) {
            lemma = lemma.toLowerCase();
        }
        return new LemmaInstance(form, lemma, use_postag ? word.getPosTag() : null, use_mtag ? word.getMorphTag() : null);
    }

    public static LemmaInstance getInstance(Word word) {
        return LemmaInstance.getInstance(word, true, true);
    }

    public void setPosTag(String string) {
        this.ptag_ = string;
    }

    public void setMorphTag(String string) {
        this.mtag_ = string;
    }
}

