/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class ForExpressionAdjunct
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        ForExpression exp = (ForExpression)this.getExpression();
        Posture p = Streamability.getStreamability(exp.getSequence(), contextInfo, reasons).getPosture();
        if (p == Posture.GROUNDED) {
            return super.computeStreamability(contextInfo, reasons);
        }
        if (reasons != null) {
            String desc = exp.getVariableQName().hasURI(NamespaceUri.SAXON_GENERATED_VARIABLE) ? exp.getSequence().toShortString() : "bound to the variable $" + exp.getVariableName();
            reasons.add("The expression " + desc + " is capable of delivering streamed nodes (line " + this.getExpression().getLocation().getLineNumber() + ")");
        }
        return PostureAndSweep.ROAMING_AND_FREE_RANGING;
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new ForExpressionFeed(this.getExpression(), out, context);
    }

    public static class ForExpressionFeed
    extends ItemFeed {
        public ForExpressionFeed(Expression expr, ItemFeed out, XPathContext context) {
            super(expr, out, context);
        }

        @Override
        public void append(Item item) throws XPathException {
            this.getContext().setLocalVariable(((ForExpression)this.getExpression()).getLocalSlotNumber(), item);
            SequenceIterator iter = ((ForExpression)this.getExpression()).getAction().iterate(this.getContext());
            ForExpressionFeed.processItems(iter, this.getNextOutputter());
        }
    }
}

