/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.StreamingSequenceWriter;
import com.saxonica.ee.stream.feed.ItemFeed;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.iter.ListIterator;

public class BufferingApplyTemplatesFeed
extends ItemFeed {
    private final List<Item> inputValue = new ArrayList<Item>(4);
    private final Component.M targetMode;

    public BufferingApplyTemplatesFeed(ApplyTemplates expr, ItemFeed result, XPathContext context) {
        super(expr, result, context);
        this.targetMode = expr.getTargetMode(context);
    }

    @Override
    public void append(Item item) throws XPathException {
        this.inputValue.add(item);
    }

    @Override
    public void close() throws XPathException {
        Item item;
        XPathContextMajor c2 = this.getContext().newContext();
        c2.trackFocus(new ListIterator.Of<Item>(this.inputValue));
        ParameterSet actualParams = Instruction.assembleParams(this.getContext(), ((ApplyTemplates)this.getExpression()).getActualParams());
        ParameterSet tunnelParams = Instruction.assembleTunnelParams(this.getContext(), ((ApplyTemplates)this.getExpression()).getTunnelParams());
        c2.setCurrentMode(this.targetMode);
        c2.setCurrentComponent(this.targetMode);
        c2.setLocalParameters(actualParams);
        c2.setTunnelParameters(tunnelParams);
        c2.setCurrentMergeGroupIterator(null);
        StreamingSequenceWriter writer = new StreamingSequenceWriter(this.getPipelineConfiguration(), this.getNextOutputter());
        ComplexContentOutputter output = new ComplexContentOutputter(writer);
        Mode mode = this.targetMode.getActor();
        FocusIterator iter = c2.getCurrentIterator();
        while ((item = iter.next()) != null) {
            Rule rule = mode.getRule(item, c2);
            if (rule == null) {
                mode.getBuiltInRuleSet().process(item, actualParams, tunnelParams, output, c2, Loc.NONE);
                continue;
            }
            TemplateRule template = (TemplateRule)rule.getAction();
            template.initialize();
            c2.openStackFrame(template.getStackFrameMap());
            c2.setCurrentTemplateRule(rule);
            template.apply(output, c2);
        }
    }
}

