/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.SegmentationInstance;
import chipmunk.segmenter.SegmentationResult;
import chipmunk.segmenter.SegmenterModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public class SegmentationDecoder {
    private SegmenterModel model_;
    private int num_tags_;
    private int max_segment_length;
    private double[] score_array_;
    private int[] tag_array_;
    private int[] index_array_;
    private int input_length_;

    public SegmentationDecoder(SegmenterModel model) {
        this.model_ = model;
        this.num_tags_ = this.model_.getNumTags();
        this.max_segment_length = this.model_.getMaxSegmentLength();
    }

    SegmentationResult decode(SegmentationInstance instance) {
        this.input_length_ = instance.getLength();
        this.checkArraySize(this.num_tags_ * this.input_length_);
        Arrays.fill(this.score_array_, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.tag_array_, -1);
        Arrays.fill(this.index_array_, -1);
        for (int l_end = 1; l_end < this.input_length_ + 1; ++l_end) {
            for (int tag = 0; tag < this.num_tags_; ++tag) {
                double best_score = Double.NEGATIVE_INFINITY;
                int best_output = -1;
                int best_index = -1;
                for (int l_start = Math.max(0, l_end - this.max_segment_length); l_start < l_end; ++l_start) {
                    double pair_score = this.model_.getPairScore(instance, l_start, l_end, tag);
                    if (l_start == 0) {
                        double score = pair_score;
                        if (!(score > best_score)) continue;
                        best_score = score;
                        best_output = -1;
                        best_index = l_start;
                        continue;
                    }
                    for (int last_tag = 0; last_tag < this.num_tags_; ++last_tag) {
                        double prev_cost = this.score_array_[this.getIndex(last_tag, l_start - 1)];
                        double transiton_score = this.model_.getTransitionScore(instance, last_tag, tag, l_start, l_end);
                        double score = pair_score + transiton_score + prev_cost;
                        if (!(score > best_score)) continue;
                        best_score = score;
                        best_output = last_tag;
                        best_index = l_start;
                    }
                }
                this.score_array_[this.getIndex((int)tag, (int)(l_end - 1))] = best_score;
                this.tag_array_[this.getIndex((int)tag, (int)(l_end - 1))] = best_output;
                this.index_array_[this.getIndex((int)tag, (int)(l_end - 1))] = best_index;
            }
        }
        SegmentationResult result = this.backTrace();
        return result;
    }

    private SegmentationResult backTrace() {
        LinkedList<Integer> tags = new LinkedList<Integer>();
        LinkedList<Integer> input_indexes = new LinkedList<Integer>();
        int end_index = this.input_length_;
        double best_score = Double.NEGATIVE_INFINITY;
        int end_tag = -1;
        for (int tag = 0; tag < this.num_tags_; ++tag) {
            double score = this.score_array_[this.getIndex(tag, end_index - 1)];
            if (!(score > best_score)) continue;
            best_score = score;
            end_tag = tag;
        }
        tags.add(end_tag);
        input_indexes.add(end_index);
        while (true) {
            int start_index = this.index_array_[this.getIndex(end_tag, end_index - 1)];
            int start_tag = this.tag_array_[this.getIndex(end_tag, end_index - 1)];
            if (start_tag < 0) break;
            tags.add(start_tag);
            input_indexes.add(start_index);
            end_tag = start_tag;
            end_index = start_index;
        }
        Collections.reverse(tags);
        Collections.reverse(input_indexes);
        return new SegmentationResult(tags, input_indexes, best_score);
    }

    private int getIndex(int tag, int index) {
        return tag * this.input_length_ + index;
    }

    private void checkArraySize(int required_length) {
        if (this.score_array_ == null || this.score_array_.length < required_length) {
            this.score_array_ = new double[required_length];
            this.tag_array_ = new int[this.score_array_.length];
            this.index_array_ = new int[this.score_array_.length];
        }
    }
}

