/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SubscriptExpression;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class SubscriptExpressionCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        GroundedValue<?> value;
        Expression sequence = ((SubscriptExpression)expression).getBaseExpression();
        Expression index = ((SubscriptExpression)expression).getSubscriptExpression();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        SubscriptExpressionCompiler.visitAnnotation(compiler, "itemAt");
        SubscriptExpressionCompiler.visitLineNumber(compiler, ga, expression);
        if (index instanceof Literal && (value = ((Literal)index).getValue()) instanceof NumericValue && ((NumericValue)value).isWholeNumber()) {
            int i;
            LabelInfo grounded = methodInfo.newLabel("grounded");
            LabelInfo memo = methodInfo.newLabel("memo");
            LabelInfo end = methodInfo.newLabel("end");
            try {
                i = (int)((NumericValue)value).longValue();
            }
            catch (XPathException e) {
                throw new AssertionError();
            }
            compiler.compileToIterator(sequence);
            ga.dup();
            ga.ifInstance(MemoSequence.ProgressiveIterator.class, memo);
            ga.dup();
            ga.invokeInstanceMethod(SequenceIterator.class, "getProperties", new Class[0]);
            ga.push(1);
            ga.math(126, Type.INT_TYPE);
            ga.ifZCmp(154, grounded.label());
            ga.push(i);
            ga.invokeStaticMethod(TailIterator.class, "make", SequenceIterator.class, Integer.TYPE);
            ga.dup();
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.swap();
            ga.invokeInstanceMethod(SequenceIterator.class, "close", new Class[0]);
            ga.goTo(end);
            methodInfo.placeLabel(memo);
            ga.checkClass(MemoSequence.ProgressiveIterator.class);
            ga.invokeInstanceMethod(MemoSequence.ProgressiveIterator.class, "getMemoSequence", new Class[0]);
            ga.push(i - 1);
            ga.invokeInstanceMethod(MemoSequence.class, "itemAt", Integer.TYPE);
            ga.goTo(end);
            methodInfo.placeLabel(grounded);
            ga.checkClass(GroundedIterator.class);
            ga.invokeInstanceMethod(GroundedIterator.class, "materialize", new Class[0]);
            ga.push(i - 1);
            ga.invokeInstanceMethod(GroundedValue.class, "itemAt", Integer.TYPE);
            methodInfo.placeLabel(end);
            return;
        }
        LabelInfo returnEmpty = methodInfo.newLabel("returnEmpty");
        LabelInfo popAndReturnEmpty = methodInfo.newLabel("popAndReturnEmpty");
        LabelInfo end = methodInfo.newLabel("end");
        if (th.isSubType(index.getItemType(), BuiltInAtomicType.INTEGER)) {
            IntegerValue[] bounds = index.getIntegerBounds();
            if (bounds != null && bounds[1].compareTo(Integer.MAX_VALUE) <= 0) {
                compiler.compileToPrimitive(index, Integer.TYPE, new OnEmpty.UnwindAndJump(returnEmpty));
            } else {
                compiler.compileToItem(index);
                if (Cardinality.allowsZero(index.getCardinality())) {
                    ga.dup();
                    ga.ifNull(end.label());
                }
                ga.checkClass(NumericValue.class);
                ga.dup();
                ga.push((long)Integer.MAX_VALUE);
                ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
                ga.ifZCmp(157, popAndReturnEmpty.label());
                ga.invokeInstanceMethod(NumericValue.class, "longValue", new Class[0]);
                ga.cast(Type.LONG_TYPE, Type.INT_TYPE);
            }
        } else {
            compiler.compileToItem(index);
            if (Cardinality.allowsZero(index.getCardinality())) {
                ga.dup();
                ga.ifNull(end.label());
            }
            ga.checkClass(NumericValue.class);
            ga.dup();
            ga.push((long)Integer.MAX_VALUE);
            ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
            ga.ifZCmp(157, popAndReturnEmpty.label());
            ga.dup();
            ga.invokeInstanceMethod(NumericValue.class, "isWholeNumber", new Class[0]);
            ga.ifFalse(popAndReturnEmpty);
            ga.invokeInstanceMethod(NumericValue.class, "longValue", new Class[0]);
            ga.cast(Type.LONG_TYPE, Type.INT_TYPE);
        }
        LabelInfo nonZero = methodInfo.newLabel("nonZero");
        LabelInfo memo = methodInfo.newLabel("memo");
        LabelInfo grounded = methodInfo.newLabel("grounded");
        ga.push(1);
        ga.math(100, Type.INT_TYPE);
        int indexVar = methodInfo.allocateLocal(Integer.TYPE);
        ga.storeLocal(indexVar);
        compiler.compileToIterator(sequence);
        ga.loadLocal(indexVar);
        ga.ifZCmp(154, nonZero.label());
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.goTo(end);
        methodInfo.placeLabel(nonZero);
        ga.dup();
        ga.ifInstance(MemoSequence.ProgressiveIterator.class, memo);
        ga.dup();
        ga.invokeInstanceMethod(SequenceIterator.class, "getProperties", new Class[0]);
        ga.push(1);
        ga.math(126, Type.INT_TYPE);
        ga.ifZCmp(154, grounded.label());
        ga.loadLocal(indexVar);
        ga.push(1);
        ga.math(96, Type.INT_TYPE);
        ga.invokeStaticMethod(TailIterator.class, "make", SequenceIterator.class, Integer.TYPE);
        ga.dup();
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.swap();
        ga.invokeInstanceMethod(SequenceIterator.class, "close", new Class[0]);
        ga.goTo(end);
        methodInfo.placeLabel(popAndReturnEmpty);
        ga.pop();
        methodInfo.placeLabel(returnEmpty);
        ga.pushNull();
        ga.goTo(end);
        methodInfo.placeLabel(memo);
        ga.checkClass(MemoSequence.ProgressiveIterator.class);
        ga.invokeInstanceMethod(MemoSequence.ProgressiveIterator.class, "getMemoSequence", new Class[0]);
        ga.loadLocal(indexVar);
        ga.invokeInstanceMethod(MemoSequence.class, "itemAt", Integer.TYPE);
        ga.goTo(end);
        methodInfo.placeLabel(grounded);
        ga.checkClass(GroundedIterator.class);
        ga.invokeInstanceMethod(GroundedIterator.class, "materialize", new Class[0]);
        ga.loadLocal(indexVar);
        ga.invokeInstanceMethod(GroundedValue.class, "itemAt", Integer.TYPE);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(indexVar);
    }
}

