/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public class AxisExpressionAdjunct
extends StreamingAdjunct {
    @Override
    public Pattern toStreamingPattern(Configuration config) {
        AxisExpression ae = (AxisExpression)this.getExpression();
        byte axis = ae.getAxis();
        try {
            if (AxisInfo.isSubtreeAxis[axis]) {
                SlashExpression s = new SlashExpression(new ContextItemExpression(), ae.copy(new RebindingMap()));
                return s.toPattern(config);
            }
            return null;
        }
        catch (XPathException e) {
            return null;
        }
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Configuration config = this.getConfiguration();
        ArrayList<String> failures = new ArrayList<String>();
        Pattern pattern = StreamingPatternMaker.makeStreamingPattern(this.getExpression(), config, failures);
        if (pattern != null) {
            return (watchManager, out, context) -> {
                if (forGrouping) {
                    out = new FilteringFeed(out, context, (item, position) -> position == 1 ? 1 : 2);
                }
                return new Trigger(pattern, out, context);
            };
        }
        return null;
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        AxisExpression exp = (AxisExpression)this.getExpression();
        Posture contextPosture = contextInfo.getContextItemPosture();
        byte axis = exp.getAxis();
        NodeTest test = exp.getNodeTest();
        switch (contextPosture) {
            case GROUNDED: {
                return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
            }
            case ROAMING: {
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            case CLIMBING: {
                switch (axis) {
                    case 0: 
                    case 1: 
                    case 9: 
                    case 12: {
                        return new PostureAndSweep(Posture.CLIMBING, Sweep.MOTIONLESS);
                    }
                    case 2: 
                    case 8: {
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                }
                AxisExpressionAdjunct.addFreeRangingMessage(exp, axis, contextPosture, reasons);
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            case STRIDING: {
                switch (axis) {
                    case 0: 
                    case 1: 
                    case 9: {
                        return new PostureAndSweep(Posture.CLIMBING, Sweep.MOTIONLESS);
                    }
                    case 2: 
                    case 8: 
                    case 12: {
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                    case 3: {
                        return new PostureAndSweep(Posture.STRIDING, Sweep.CONSUMING);
                    }
                    case 4: 
                    case 5: {
                        if (Streamability.isChildlessNodeKind(test)) {
                            return new PostureAndSweep(Posture.STRIDING, Sweep.CONSUMING);
                        }
                        return new PostureAndSweep(Posture.CRAWLING, Sweep.CONSUMING);
                    }
                }
                AxisExpressionAdjunct.addFreeRangingMessage(exp, axis, contextPosture, reasons);
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            case CRAWLING: {
                switch (axis) {
                    case 0: 
                    case 1: 
                    case 9: {
                        return new PostureAndSweep(Posture.CLIMBING, Sweep.MOTIONLESS);
                    }
                    case 2: 
                    case 8: {
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                    case 12: {
                        return new PostureAndSweep(Posture.CRAWLING, Sweep.MOTIONLESS);
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!Streamability.isChildlessNodeKind(test)) break;
                        return new PostureAndSweep(Posture.STRIDING, Sweep.CONSUMING);
                    }
                }
                AxisExpressionAdjunct.addFreeRangingMessage(exp, axis, contextPosture, reasons);
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
        }
        return PostureAndSweep.ROAMING_AND_FREE_RANGING;
    }

    private static void addFreeRangingMessage(Expression exp, int axis, Posture contextPosture, List<String> reasons) {
        if (reasons != null) {
            reasons.add("Cannot use the " + AxisInfo.axisName[axis] + " axis when context posture is " + contextPosture + " (line " + exp.getLocation().getLineNumber() + ")");
        }
    }
}

