/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SignificantItemDetector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ConditionalBlock;
import net.sf.saxon.expr.instruct.OnEmptyExpr;
import net.sf.saxon.expr.instruct.OnNonEmptyExpr;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class ConditionalBlockAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    private int consumingArg = -1;

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        this.consumingArg = ConditionalBlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return super.getWatchMaker(forGrouping);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        this.consumingArg = ConditionalBlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return new ConditionalBlockFeed((ConditionalBlock)this.getExpression(), this.consumingArg, out, context);
    }

    public static class ConditionalBlockFeed
    extends ItemFeed {
        int consumingArg;
        boolean empty = true;
        private boolean consumingArgIsOnEmpty = false;
        List<OnEmptyExpr> emptyPendingList = new ArrayList<OnEmptyExpr>();
        List<OnNonEmptyExpr> nonEmptyPendingList = new ArrayList<OnNonEmptyExpr>();
        List<Item> tentativeContent = null;

        public ConditionalBlockFeed(ConditionalBlock exp, int arg, Feed result, XPathContext context) {
            super(exp, result, context);
            this.consumingArg = arg;
            this.consumingArgIsOnEmpty = exp.getChildExpression(arg) instanceof OnEmptyExpr;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void addTentativeContent(Item item) {
            if (this.tentativeContent == null) {
                this.tentativeContent = new ArrayList<Item>();
            }
            this.tentativeContent.add(item);
        }

        private boolean isSignificant(Item item) {
            return SignificantItemDetector.isSignificant(item);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            ConditionalBlock block = (ConditionalBlock)this.getExpression();
            Feed result = this.getResult();
            for (int i = 0; i < this.consumingArg; ++i) {
                Expression child = block.getChildExpression(i);
                if (child instanceof OnEmptyExpr) {
                    if (!this.empty) continue;
                    this.emptyPendingList.add((OnEmptyExpr)child);
                    continue;
                }
                if (child instanceof OnNonEmptyExpr) {
                    if (this.empty) {
                        this.nonEmptyPendingList.add((OnNonEmptyExpr)child);
                        continue;
                    }
                    SequenceIterator<?> iter = child.iterate(this.getContext());
                    ConditionalBlockFeed.processItems(iter, result);
                    continue;
                }
                child.iterate(this.getContext()).forEachOrFail(item -> {
                    if (this.empty && this.isSignificant(item)) {
                        this.empty = false;
                        for (OnNonEmptyExpr e : this.nonEmptyPendingList) {
                            SequenceIterator<?> si = e.iterate(this.getContext());
                            ConditionalBlockFeed.processItems(si, result);
                        }
                    }
                    result.processItem(item);
                });
            }
        }

        @Override
        public void close() throws XPathException {
            if (this.consumingArgIsOnEmpty) {
                this.empty = true;
            }
            ConditionalBlock block = (ConditionalBlock)this.getExpression();
            Feed result = this.getResult();
            for (int i = this.consumingArg + 1; i < block.size(); ++i) {
                Expression child = block.getChildExpression(i);
                if (child instanceof OnEmptyExpr) {
                    if (!this.empty) continue;
                    this.emptyPendingList.add((OnEmptyExpr)child);
                    continue;
                }
                if (child instanceof OnNonEmptyExpr) {
                    if (this.empty) {
                        this.nonEmptyPendingList.add((OnNonEmptyExpr)child);
                        continue;
                    }
                    ConditionalBlockFeed.processItems(child.iterate(this.getContext()), this.getResult());
                    continue;
                }
                child.iterate(this.getContext()).forEachOrFail(item -> {
                    if (this.isSignificant(item)) {
                        this.flushTentativeContent(result);
                        this.empty = false;
                    }
                    result.processItem(item);
                });
            }
            if (this.empty) {
                for (OnEmptyExpr e : this.emptyPendingList) {
                    SequenceIterator<?> si = e.iterate(this.getContext());
                    ConditionalBlockFeed.processItems(si, result);
                }
            }
            result.close();
        }

        private void flushTentativeContent(Feed out) throws XPathException {
            if (this.tentativeContent != null && !this.tentativeContent.isEmpty()) {
                for (Item item : this.tentativeContent) {
                    out.processItem(item);
                }
                this.tentativeContent = null;
                this.empty = false;
            }
            for (Expression expression : this.nonEmptyPendingList) {
                ConditionalBlockFeed.processItems(expression.iterate(this.getContext()), this.getResult());
            }
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (this.empty && this.isSignificant(item)) {
                this.empty = false;
                for (OnNonEmptyExpr e : this.nonEmptyPendingList) {
                    SequenceIterator<?> si = e.iterate(this.getContext());
                    ConditionalBlockFeed.processItems(si, this.getResult());
                }
            }
            this.getResult().processItem(item);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.empty) {
                this.empty = false;
                for (OnNonEmptyExpr e : this.nonEmptyPendingList) {
                    SequenceIterator<?> si = e.iterate(this.getContext());
                    ConditionalBlockFeed.processItems(si, this.getResult());
                }
            }
            return this.getResult().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResult().endSelectedParentNode(locationId);
        }

        @Override
        public Receiver getReceiver() {
            return new SignificantItemDetector(super.getReceiver(), () -> this.flushTentativeContent(this.getResult()));
        }
    }
}

