/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.trans.CountingCompletionService;
import com.saxonica.ee.trans.Outcome;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.trans.XPathException;

public class ThreadManagerEE
extends XPathContextMajor.ThreadManager {
    private EnterpriseConfiguration config;
    private ExecutorService executorService = null;
    private CountingCompletionService<Outcome<Boolean>> completionService = null;

    public ThreadManagerEE(EnterpriseConfiguration config) {
        this.config = config;
    }

    public CountingCompletionService<Outcome<Boolean>> getCompletionService() {
        if (this.completionService == null) {
            this.activate();
        }
        return this.completionService;
    }

    private synchronized void activate() {
        if (this.completionService == null) {
            int threads = this.config.getResultDocumentThreadsLimit();
            if (threads < 1) {
                threads = 1;
            }
            this.executorService = this.config.getMultithreadingFactory().makeExecutorService(threads);
            if (this.executorService instanceof ThreadPoolExecutor) {
                ((ThreadPoolExecutor)this.executorService).setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            }
            this.completionService = new CountingCompletionService(this.executorService);
        }
    }

    @Override
    public synchronized void waitForChildThreads() throws XPathException {
        if (this.executorService == null) {
            return;
        }
        try {
            while (this.completionService.hasUncompletedTasks()) {
                Outcome<Boolean> result = this.completionService.take().get();
                if (result.isSuccess()) continue;
                Exception e = result.getException();
                if (!(e instanceof XPathException)) {
                    e.printStackTrace();
                }
                throw XPathException.makeXPathException(e);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new XPathException(e);
        }
        finally {
            this.executorService.shutdown();
            try {
                boolean finished = this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
                if (!finished) {
                    System.err.println("Some child xsl:result-document threads have not finished");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

