/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.optim.SwitchExpression;
import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoOpenFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.value.AtomicValue;

public class SwitchAdjunct
extends TransmissionAdjunct {
    private Map<Operand, Inversion> actionInversions;

    @Override
    public void setExpression(Expression expression) {
        super.setExpression(expression);
        this.actionInversions = new HashMap<Operand, Inversion>(((SwitchExpression)this.getExpression()).getCaseMap().size());
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        SwitchExpression exp = (SwitchExpression)this.getExpression();
        return (watchManager, out, context) -> {
            Operand selected;
            out.open(new Terminator());
            out = new NoOpenFeed(out, context);
            AtomicValue subjectValue = (AtomicValue)exp.getSubjectExpression().evaluateItem(context);
            if (subjectValue == null) {
                selected = exp.getOtherwiseOperand();
            } else {
                AtomicMatchKey key = subjectValue.getXPathMatchKey(exp.getCollation(), context.getImplicitTimezone());
                Map<AtomicMatchKey, Integer> caseMap = exp.getCaseMap();
                selected = caseMap.containsKey(key) ? exp.getAction(caseMap.get(key)) : exp.getOtherwiseOperand();
            }
            Expression action = selected.getChildExpression();
            if (Streamability.getSweep(action) == Sweep.CONSUMING) {
                Inversion actionInversion = this.actionInversions.get(selected);
                if (actionInversion == null) {
                    actionInversion = Inversion.invertExpression(action, forGrouping);
                    this.actionInversions.put(selected, actionInversion);
                }
                return actionInversion.getWatch(watchManager, out, context);
            }
            SequenceTool.supply(action.iterate(context), out::append);
            return new Trigger(new NodeTestPattern(ErrorType.getInstance()), new FilteringFeed(watchManager, out, context, FilteringFeed.OpaqueFilter), context);
        };
    }

    @Override
    public Trigger makeTransmissionFlow(WatchManager watchManager, Expression exp, ItemFeed out, XPathContext context) throws XPathException {
        WatchMaker wm = this.getWatchMaker(false);
        if (wm != null) {
            return wm.makeWatch(watchManager, out, context);
        }
        throw new XPathException("Choose expression too complex for streaming", "XTSE3430");
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return this.getFeedMaker(-1).makeItemFeed(watchManager, out, context);
    }
}

