/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

public class ChunkerEventStream
extends AbstractEventStream<ChunkSample> {
    private final ChunkerContextGenerator cg;

    public ChunkerEventStream(ObjectStream<ChunkSample> d, ChunkerContextGenerator cg) {
        super(d);
        this.cg = cg;
    }

    @Override
    protected Iterator<Event> createEvents(ChunkSample sample2) {
        if (sample2 != null) {
            ArrayList<Event> events = new ArrayList<Event>();
            String[] toksArray = sample2.getSentence();
            String[] tagsArray = sample2.getTags();
            String[] predsArray = sample2.getPreds();
            int el = sample2.getSentence().length;
            for (int ei = 0; ei < el; ++ei) {
                events.add(new Event(predsArray[ei], this.cg.getContext(ei, toksArray, tagsArray, predsArray)));
            }
            return events.iterator();
        }
        return Collections.emptyListIterator();
    }
}

