/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.DistanceConstraint;
import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.MultipleDistanceSpans;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanMultipleDistanceQuery
extends SimpleSpanQuery {
    private List<DistanceConstraint> constraints;
    private boolean isOrdered;
    private String spanName;

    public SpanMultipleDistanceQuery(SpanQuery firstClause, SpanQuery secondClause, List<DistanceConstraint> constraints, boolean isOrdered, boolean collectPayloads) {
        super(firstClause, secondClause, collectPayloads);
        this.constraints = constraints;
        this.isOrdered = isOrdered;
        this.spanName = "spanMultipleDistance";
    }

    @Override
    public SpanMultipleDistanceQuery clone() {
        SpanMultipleDistanceQuery query = new SpanMultipleDistanceQuery((SpanQuery)this.firstClause.clone(), (SpanQuery)this.secondClause.clone(), this.constraints, this.isOrdered, this.collectPayloads);
        query.setBoost(this.getBoost());
        return query;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.spanName);
        sb.append("(");
        sb.append(this.firstClause.toString(field));
        sb.append(", ");
        sb.append(this.secondClause.toString(field));
        sb.append(", ");
        sb.append("[");
        int size = this.constraints.size();
        for (int i = 0; i < size; ++i) {
            DistanceConstraint c = this.constraints.get(i);
            sb.append("(");
            sb.append(c.getUnit());
            sb.append("[");
            sb.append(c.getMinDistance());
            sb.append(":");
            sb.append(c.getMaxDistance());
            sb.append("], ");
            sb.append(c.isOrdered() ? "ordered, " : "notOrdered, ");
            sb.append(c.isExclusion() ? "excluded)" : "notExcluded)");
            if (i >= size - 1) continue;
            sb.append(", ");
        }
        sb.append("])");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        MultipleDistanceSpans mds = null;
        SpanDistanceQuery sdq = new SpanDistanceQuery(this.firstClause, this.secondClause, this.constraints.get(0), this.collectPayloads);
        Spans ds = sdq.getSpans(context, acceptDocs, termContexts);
        for (int i = 1; i < this.constraints.size(); ++i) {
            SpanDistanceQuery sdq2 = new SpanDistanceQuery(this.firstClause, this.secondClause, this.constraints.get(i), this.collectPayloads);
            Spans ds2 = sdq2.getSpans(context, acceptDocs, termContexts);
            boolean exclusion = sdq.isExclusion() && sdq2.isExclusion();
            mds = new MultipleDistanceSpans(this, context, acceptDocs, termContexts, ds, ds2, this.isOrdered, exclusion);
            ds = mds;
        }
        return mds;
    }

    public List<DistanceConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<DistanceConstraint> constraints) {
        this.constraints = constraints;
    }
}

