/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.AncestorPatternOptimizer;
import com.saxonica.ee.trans.Characteristic;
import com.saxonica.ee.trans.ContainsTokenPatternOptimizer;
import com.saxonica.ee.trans.EqualityPatternOptimizer;
import com.saxonica.ee.trans.IntEqualityPatternOptimizer;
import com.saxonica.ee.trans.PatternOptimizer;
import com.saxonica.ee.trans.Precondition;
import com.saxonica.ee.trans.RuleEE;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.pattern.Pattern;

public class GeneralPatternOptimizer
extends PatternOptimizer {
    private static final List<PatternOptimizer> patternOptimizers = new ArrayList<PatternOptimizer>();
    private static final GeneralPatternOptimizer THE_INSTANCE;

    public static GeneralPatternOptimizer getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public boolean appliesTo(Pattern pattern) {
        return true;
    }

    @Override
    public void process(RuleEE rule, Pattern pattern, Map<Precondition, List<RuleEE>> preconditions, Map<Characteristic, Characteristic> characteristics) {
        for (PatternOptimizer optimizer : patternOptimizers) {
            if (!optimizer.appliesTo(pattern)) continue;
            optimizer.process(rule, pattern, preconditions, characteristics);
            break;
        }
    }

    static {
        patternOptimizers.add(EqualityPatternOptimizer.getInstance());
        patternOptimizers.add(ContainsTokenPatternOptimizer.getInstance());
        patternOptimizers.add(IntEqualityPatternOptimizer.getInstance());
        patternOptimizers.add(AncestorPatternOptimizer.getInstance());
        THE_INSTANCE = new GeneralPatternOptimizer();
    }
}

