/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.NextSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanNextQuery
extends SimpleSpanQuery
implements Cloneable {
    public SpanNextQuery(SpanQuery firstClause, SpanQuery secondClause) {
        this(firstClause, secondClause, true);
    }

    public SpanNextQuery(SpanQuery firstClause, SpanQuery secondClause, boolean collectPayloads) {
        super(firstClause, secondClause, collectPayloads);
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new NextSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public SpanNextQuery clone() {
        SpanNextQuery spanNextQuery = new SpanNextQuery((SpanQuery)this.firstClause.clone(), (SpanQuery)this.secondClause.clone(), this.collectPayloads);
        spanNextQuery.setBoost(this.getBoost());
        return spanNextQuery;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanNextQuery clone = null;
        SpanQuery query = (SpanQuery)this.firstClause.rewrite(reader);
        if (query != this.firstClause) {
            if (clone == null) {
                clone = this.clone();
            }
            clone.firstClause = query;
        }
        if ((query = (SpanQuery)this.secondClause.rewrite(reader)) != this.secondClause) {
            if (clone == null) {
                clone = this.clone();
            }
            clone.secondClause = query;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("spanNext(");
        sb.append(this.firstClause.toString(field));
        sb.append(", ");
        sb.append(this.secondClause.toString(field));
        sb.append(")");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanNextQuery)) {
            return false;
        }
        SpanNextQuery spanNextQuery = (SpanNextQuery)o;
        if (this.collectPayloads != spanNextQuery.collectPayloads) {
            return false;
        }
        if (!this.firstClause.equals(spanNextQuery.firstClause)) {
            return false;
        }
        if (!this.secondClause.equals(spanNextQuery.secondClause)) {
            return false;
        }
        return this.getBoost() == spanNextQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int result = this.firstClause.hashCode() + this.secondClause.hashCode();
        result ^= result << 31 | result >>> 2;
        return result += Float.floatToRawIntBits(this.getBoost());
    }
}

