/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.test.segmenter;

import chipmunk.segmenter.Scorer;
import chipmunk.segmenter.SegmentationDataReader;
import chipmunk.segmenter.Segmenter;
import chipmunk.segmenter.SegmenterOptions;
import chipmunk.segmenter.SegmenterTrainer;
import java.util.logging.Logger;
import marmot.util.Copy;
import marmot.util.Numerics;
import org.junit.Assert;
import org.junit.Test;

public class SegmenterTest {
    @Test
    public void trainAccuracyTest() {
        String trainfile = "res:///chipmunk/test/segmenter/data/eng/trn";
        SegmentationDataReader reader = new SegmentationDataReader(trainfile, "eng", 0);
        SegmenterOptions options = new SegmenterOptions();
        options.setOption("lang", "eng");
        SegmenterTrainer trainer = new SegmenterTrainer(options);
        Segmenter segmenter = trainer.train(reader.getData());
        segmenter = Copy.clone(segmenter);
        Logger logger = Logger.getLogger(this.getClass().getName());
        Scorer scorer = new Scorer();
        scorer.eval(reader.getData(), segmenter);
        logger.info(scorer.report());
        double fscore = scorer.getFscore();
        Assert.assertTrue((boolean)Numerics.approximatelyGreaterEqual(fscore, 99.0));
    }

    @Test
    public void crfTrainAccuracyTest() {
        String trainfile = "res:///chipmunk/test/segmenter/data/eng/trn";
        SegmentationDataReader reader = new SegmentationDataReader(trainfile, "eng", 0);
        SegmenterOptions options = new SegmenterOptions();
        options.setOption("lang", "eng");
        options.setOption("crf-mode", true);
        SegmenterTrainer trainer = new SegmenterTrainer(options);
        Segmenter segmenter = trainer.train(reader.getData());
        segmenter = Copy.clone(segmenter);
        Logger logger = Logger.getLogger(this.getClass().getName());
        Scorer scorer = new Scorer();
        scorer.eval(reader.getData(), segmenter);
        logger.info(scorer.report());
        double fscore = scorer.getFscore();
        Assert.assertTrue((boolean)Numerics.approximatelyGreaterEqual(fscore, 99.0));
    }
}

