/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import marmot.util.FileUtils;

public class Mapping
extends AbstractMap<String, String> {
    Map<String, String> map_;

    public Mapping(String filename) {
        this.init(filename);
    }

    private void init(String filename) {
        this.map_ = new HashMap<String, String>();
        try {
            BufferedReader reader = FileUtils.openFile(filename);
            while (reader.ready()) {
                String line = reader.readLine();
                if ((line = line.trim()).length() == 0) continue;
                String[] tokens = line.split("\\s");
                if (tokens.length != 2) {
                    reader.close();
                    throw new RuntimeException(String.format("Invalid line: %s\n", line));
                }
                String fine = tokens[0];
                String coarse = tokens[1];
                this.map_.put(fine, coarse);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String get(String key) {
        String value = this.map_.get(key);
        if (value == null) {
            throw new RuntimeException(String.format("Unknown key: %s", key));
        }
        return value;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.map_.entrySet();
    }
}

