/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.SpanReferenceQuery;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.util.QueryException;
import org.apache.lucene.search.spans.SpanQuery;

public class SpanReferenceQueryWrapper
extends SpanQueryWrapper {
    private SpanQueryWrapper subQuery;
    private byte classNum;

    public SpanReferenceQueryWrapper(SpanQueryWrapper subQueryWrapper, int classNum) {
        this.subQuery = subQueryWrapper;
        if (this.subQuery == null) {
            return;
        }
        this.isNull = false;
        if (this.subQuery.isEmpty) {
            this.isEmpty = true;
            return;
        }
        if (classNum < 0) {
            throw new IllegalArgumentException("Class number must be bigger than 0.");
        }
        this.classNum = (byte)classNum;
        this.maybeUnsorted = subQueryWrapper.maybeUnsorted();
    }

    @Override
    public SpanQuery toFragmentQuery() throws QueryException {
        if (this.isNull() || this.isEmpty()) {
            return null;
        }
        SpanQuery sq = this.subQuery.retrieveNode(this.retrieveNode).toFragmentQuery();
        if (sq == null) {
            return null;
        }
        return new SpanReferenceQuery(sq, this.classNum, true);
    }
}

