/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordTagSampleStream
extends FilterObjectStream<String, POSSample> {
    private static final Logger logger = LoggerFactory.getLogger(WordTagSampleStream.class);

    public WordTagSampleStream(ObjectStream<String> sentences) {
        super(sentences);
    }

    @Override
    public POSSample read() throws IOException {
        String sentence = (String)this.samples.read();
        if (sentence != null) {
            POSSample sample2;
            try {
                sample2 = POSSample.parse(sentence);
            }
            catch (InvalidFormatException e) {
                logger.warn("Error during parsing, ignoring sentence: {}", (Object)sentence, (Object)e);
                sample2 = new POSSample(new String[0], new String[0]);
            }
            return sample2;
        }
        return null;
    }
}

