/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.StreamingSequenceWriter;
import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.ComplexNodeEventFeed;
import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.validate.CatchingReceiver;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorManager;
import net.sf.saxon.expr.accum.IAccumulatorData;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.z.IntHashMap;

public class CopyOfFeed
extends AbsorptionFeed {
    private WatchManager watchManager;
    private boolean copyNamespaces = true;
    private boolean copyAccumulators = true;
    private int validation = 3;
    private SchemaType type = null;
    private XPathException validationError;
    private SequenceReceiver proxy;

    public static Trigger getWatch(Feed result, Pattern selection, WatchManager wm, XPathContext context) {
        CopyOfFeed action = new CopyOfFeed(wm, result, context);
        Trigger watch = new Trigger(selection, action, context);
        watch.setPipelineConfiguration(wm.getPipelineConfiguration());
        return watch;
    }

    public CopyOfFeed(WatchManager watchManager, Feed result, XPathContext context) {
        super(result, context);
        this.watchManager = watchManager;
        this.proxy = new StreamingSequenceWriter(this.getPipelineConfiguration(), result);
    }

    @Override
    public void close() throws XPathException {
        if (this.hasFailed()) {
            if (this.validationError != null) {
                this.dynamicError(this.validationError);
            } else {
                this.dynamicError(new XPathException("Streamed copy-of has failed. A validation error, perhaps?)"));
            }
        }
        super.close();
    }

    public void setCopyNamespaces(boolean copy) {
        this.copyNamespaces = copy;
    }

    public void setCopyAccumulators(boolean copy) {
        this.copyAccumulators = copy;
    }

    public void setValidationOptions(int validation, SchemaType type) {
        this.validation = validation;
        this.type = type;
    }

    @Override
    public SequenceReceiver getReceiver() {
        return this.proxy;
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) {
        return new PendingCopyAction(sequenceNr, node);
    }

    @Override
    protected Sequence<?> processGroundedItem(Item item) throws XPathException {
        ExplicitLocation loc = ExplicitLocation.UNKNOWN_LOCATION;
        if (item instanceof NodeInfo) {
            int kind = ((NodeInfo)item).getNodeKind();
            if (kind == 2) {
                NodeInfo node = (NodeInfo)item;
                Configuration config = this.getContext().getConfiguration();
                Orphan orphan = new Orphan(config);
                orphan.setNodeKind((short)node.getNodeKind());
                orphan.setNodeName(NameOfNode.makeName(node));
                orphan.setStringValue(item.getStringValue());
                orphan.setTypeAnnotation(node.getSchemaType());
                if (this.validation != 3 || this.type != null) {
                    if (this.type != null && !this.type.isSimpleType()) {
                        throw new XPathException("When copying an attribute with schema validation, the requested type must not be a complex type", "XTTE1535", this.getExpression().getLocation());
                    }
                    SimpleType annotation = CopyOf.validateAttribute(node, (SimpleType)this.type, this.validation, this.getContext());
                    orphan.setTypeAnnotation(annotation);
                }
                return orphan;
            }
            if (kind == 1 || kind == 9) {
                if (!this.copyNamespaces) {
                    SequenceOutputter writer = new SequenceOutputter(this.getPipelineConfiguration());
                    ((NodeInfo)item).copy(writer, 0, loc);
                    return writer.getFirstItem();
                }
                if (this.validation != 3 || this.type != null) {
                    Receiver copier;
                    NodeInfo node = (NodeInfo)item;
                    ParseOptions validationOptions = new ParseOptions();
                    validationOptions.setSchemaValidationMode(this.validation);
                    validationOptions.setTopLevelType(this.type);
                    Configuration config = this.getPipelineConfiguration().getConfiguration();
                    SequenceOutputter writer = new SequenceOutputter(this.getPipelineConfiguration());
                    if (kind == 9) {
                        copier = config.getDocumentValidator(writer, node.getBaseURI(), validationOptions, loc);
                    } else {
                        validationOptions.setTopLevelElement(NameOfNode.makeName(node).getStructuredQName());
                        copier = config.getElementValidator(writer, validationOptions, loc);
                    }
                    node.copy(copier, 2, loc);
                    return writer.getFirstItem();
                }
            }
        }
        return item;
    }

    @Override
    public void dynamicError(XPathException error) throws XPathException {
        super.dynamicError(error);
        this.proxy = new Sink(this.getPipelineConfiguration());
    }

    private static class CopiedAccumulatorData
    implements IAccumulatorData {
        private Accumulator accumulator;
        private IntHashMap<Sequence<?>> preDescentValues = new IntHashMap();
        private IntHashMap<Sequence<?>> postDescentValues = new IntHashMap();

        public CopiedAccumulatorData(Accumulator acc) {
            this.accumulator = acc;
        }

        public void addValues(TinyNodeImpl node, Sequence<?> preDescent, Sequence<?> postDescent) {
            this.preDescentValues.put(node.getNodeNumber(), preDescent);
            this.postDescentValues.put(node.getNodeNumber(), postDescent);
        }

        @Override
        public Accumulator getAccumulator() {
            return this.accumulator;
        }

        @Override
        public Sequence<?> getValue(NodeInfo node, boolean postDescent) {
            int nodeNr = ((TinyNodeImpl)node).getNodeNumber();
            return postDescent ? this.postDescentValues.get(nodeNr) : this.preDescentValues.get(nodeNr);
        }
    }

    public static class AccumulatorCopier
    extends ProxyReceiver {
        private WatchManager watchManager;
        private TinyBuilder builder;
        private Map<Accumulator, CopiedAccumulatorData> dataMap = new HashMap<Accumulator, CopiedAccumulatorData>();
        int depth = 0;

        public AccumulatorCopier(WatchManager watchManager, Receiver next, TinyBuilder builder) {
            super(next);
            this.builder = builder;
            this.watchManager = watchManager;
            Map<Accumulator, AccumulatorWatch> accumulators = watchManager.getAccumulatorWatchMap();
            if (accumulators != null) {
                for (AccumulatorWatch watch : accumulators.values()) {
                    this.dataMap.put(watch.getAccumulator(), new CopiedAccumulatorData(watch.getAccumulator()));
                }
            }
        }

        @Override
        public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
            super.startElement(elemName, typeCode, location, properties);
            this.depth = this.watchManager.getDepth();
        }

        @Override
        public void endElement() throws XPathException {
            super.endElement();
            --this.depth;
            TinyNodeImpl newNode = this.builder.getLastCompletedElement();
            Map<Accumulator, AccumulatorWatch> accumulators = this.watchManager.getAccumulatorWatchMap();
            if (accumulators != null) {
                for (AccumulatorWatch watch : accumulators.values()) {
                    Accumulator acc = watch.getAccumulator();
                    CopiedAccumulatorData data = this.dataMap.get(acc);
                    data.addValues(newNode, watch.getPreDescentValueAtDepth(this.depth), watch.getPostDescentValue());
                }
            }
        }

        @Override
        public void close() throws XPathException {
            Controller controller = this.watchManager.getPipelineConfiguration().getController();
            if (controller instanceof XsltController) {
                AccumulatorManager manager = ((XsltController)controller).getAccumulatorManager();
                TinyTree tree = this.builder.getTree();
                Map<Accumulator, AccumulatorWatch> accumulatorWatchMap = this.watchManager.getAccumulatorWatchMap();
                if (accumulatorWatchMap != null) {
                    for (Accumulator acc : accumulatorWatchMap.keySet()) {
                        manager.addAccumulatorData(tree, acc, this.dataMap.get(acc));
                    }
                }
                for (CopiedAccumulatorData data : this.dataMap.values()) {
                    manager.addAccumulatorData(tree, data.getAccumulator(), data);
                }
            }
        }
    }

    private class PendingCopyAction
    extends AbsorptionFeed.PendingItem {
        private TinyBuilder builder;
        private Receiver destination;
        private FleetingParentNode rootOfCopy;

        public PendingCopyAction(int sequence, FleetingParentNode node) {
            super(sequence);
            this.rootOfCopy = node;
            PipelineConfiguration pipe = CopyOfFeed.this.getPipelineConfiguration();
            if (CopyOfFeed.this.valuesReadyToBeOutput.isEmpty() && (CopyOfFeed.this.getResult() instanceof DecomposingFeed || CopyOfFeed.this.getResult() instanceof ComplexNodeEventFeed)) {
                Receiver r = CopyOfFeed.this.getResult().getReceiver();
                this.destination = new ProxyReceiver(r){

                    @Override
                    public void open() {
                    }

                    @Override
                    public void close() {
                    }
                };
            } else {
                this.builder = new TinyBuilder(pipe);
                this.builder.setStatistics(pipe.getConfiguration().getTreeStatistics().TEMPORARY_TREE_STATISTICS);
                this.destination = this.builder;
                if (CopyOfFeed.this.copyAccumulators) {
                    this.destination = new AccumulatorCopier(CopyOfFeed.this.watchManager, this.builder, this.builder);
                }
            }
        }

        @Override
        public Receiver getGatherer() throws XPathException {
            Receiver copier = this.destination;
            if (!CopyOfFeed.this.copyNamespaces) {
                copier = new NamespaceReducer(copier);
                copier = new ProxyReceiver(copier){

                    @Override
                    public void namespace(NamespaceBindingSet namespaceBindings, int properties) {
                    }
                };
            }
            if (CopyOfFeed.this.validation != 3 || CopyOfFeed.this.type != null) {
                ExplicitLocation loc;
                ParseOptions validationOptions = new ParseOptions();
                validationOptions.setSchemaValidationMode(CopyOfFeed.this.validation);
                validationOptions.setTopLevelType(CopyOfFeed.this.type);
                Configuration config = CopyOfFeed.this.getPipelineConfiguration().getConfiguration();
                Location location = loc = CopyOfFeed.this.getExpression() == null ? ExplicitLocation.UNKNOWN_LOCATION : CopyOfFeed.this.getExpression().getLocation();
                if (this.rootOfCopy.getNodeKind() == 9) {
                    copier = config.getDocumentValidator(copier, this.rootOfCopy.getBaseURI(), validationOptions, loc);
                } else {
                    if (!(copier instanceof SequenceReceiver)) {
                        copier = new TreeReceiver(copier);
                    }
                    validationOptions.setTopLevelElement(NameOfNode.makeName(this.rootOfCopy).getStructuredQName());
                    try {
                        copier = config.getElementValidator(copier, validationOptions, loc);
                    }
                    catch (XPathException e) {
                        CopyOfFeed.this.dynamicError(e);
                        return null;
                    }
                }
                PipelineConfiguration newPipe = new PipelineConfiguration(CopyOfFeed.this.getPipelineConfiguration());
                newPipe.setErrorListener(new UnfailingErrorListener(){
                    private int errorCount = 0;

                    @Override
                    public void warning(TransformerException exception) {
                    }

                    @Override
                    public void error(TransformerException exception) {
                        if (this.errorCount++ == 0) {
                            try {
                                XPathException xe = XPathException.makeXPathException(exception);
                                CopyOfFeed.this.validationError = xe;
                                CopyOfFeed.this.dynamicError(xe);
                            }
                            catch (XPathException xPathException) {
                                // empty catch block
                            }
                        }
                    }

                    @Override
                    public void fatalError(TransformerException exception) {
                        if (this.errorCount++ == 0) {
                            try {
                                XPathException xe = XPathException.makeXPathException(exception);
                                CopyOfFeed.this.validationError = xe;
                                CopyOfFeed.this.dynamicError(xe);
                            }
                            catch (XPathException xPathException) {
                                // empty catch block
                            }
                        }
                    }
                });
                copier.setPipelineConfiguration(newPipe);
                copier = new CatchingReceiver(copier, newPipe.getErrorListener());
            }
            return copier;
        }

        @Override
        public Sequence<?> deliver() throws XPathException {
            if (CopyOfFeed.this.hasFailed()) {
                if (CopyOfFeed.this.validationError != null) {
                    throw CopyOfFeed.this.validationError;
                }
                throw new XPathException("Streamed copy-of has failed. Perhaps a validation error?");
            }
            if (this.builder != null) {
                return this.builder.getCurrentRoot();
            }
            return EmptySequence.getInstance();
        }

        @Override
        public void rollback() {
        }
    }
}

