/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Transform;
import net.sf.saxon.option.jdom2.JDOM2DocumentWrapper;
import net.sf.saxon.trans.XPathException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class JDOM2Transform
extends Transform {
    public List preprocess(List sources) throws XPathException {
        try {
            ArrayList<JDOM2DocumentWrapper> jdomSources = new ArrayList<JDOM2DocumentWrapper>(sources.size());
            for (int i = 0; i < sources.size(); ++i) {
                InputSource is;
                Source ss;
                Source src = (Source)sources.get(i);
                if (src instanceof SAXSource) {
                    ss = (SAXSource)sources.get(i);
                    is = ((SAXSource)ss).getInputSource();
                } else if (src instanceof StreamSource) {
                    ss = (StreamSource)src;
                    is = ((StreamSource)ss).getInputStream() != null ? new InputSource(((StreamSource)ss).getInputStream()) : (((StreamSource)ss).getReader() != null ? new InputSource(((StreamSource)ss).getReader()) : new InputSource(((StreamSource)ss).getSystemId()));
                } else {
                    throw new IllegalArgumentException("Unknown kind of source");
                }
                is.setSystemId(src.getSystemId());
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                doc.setBaseURI(is.getSystemId());
                JDOM2DocumentWrapper jdom = new JDOM2DocumentWrapper(doc, this.getConfiguration());
                jdomSources.add(jdom);
            }
            return jdomSources;
        }
        catch (JDOMException e) {
            throw new XPathException(e);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static void main(String[] args) {
        new JDOM2Transform().doTransform(args, "JDOM2Transform");
    }
}

