/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.rules;

import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import marmot.tokenize.rules.Rule;
import marmot.tokenize.rules.RuleProvider;

public class EnglishRuleProvider
extends RuleProvider {
    @Override
    public Collection<Rule> getTokRules() {
        LinkedList<Rule> rules = new LinkedList<Rule>();
        rules.add(new Rule(Pattern.compile("(``)"), "\""));
        rules.add(new Rule(Pattern.compile("(`)"), "'"));
        rules.add(new Rule(Pattern.compile("('')"), "\""));
        rules.add(new Rule(Pattern.compile("(--)"), "-"));
        rules.add(new Rule(Pattern.compile("(\\.\\.\\.)"), "\u2026"));
        rules.add(new Rule(Pattern.compile("(\\. \\.)$"), "."));
        return rules;
    }

    @Override
    public Collection<Rule> getUnTokRules() {
        LinkedList<Rule> rules = new LinkedList<Rule>();
        rules.add(new Rule(Pattern.compile("(\\()"), "-LRB-"));
        rules.add(new Rule(Pattern.compile("(\\))"), "-RRB-"));
        rules.add(new Rule(Pattern.compile("(\\{)"), "-LCB-"));
        rules.add(new Rule(Pattern.compile("(\\})"), "-RCB-"));
        rules.add(new Rule(Pattern.compile("(\\[)"), "-LSB-"));
        rules.add(new Rule(Pattern.compile("(\\])"), "-RSB-"));
        rules.add(new Rule(Pattern.compile("(\u00bc)"), "1/4"));
        rules.add(new Rule(Pattern.compile("(\\. ?\\.)$"), "."));
        return rules;
    }
}

