/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public class CastableExpressionCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        ItemType itemType;
        CastableExpression castableExpr = (CastableExpression)expression;
        Expression operand = castableExpr.getBaseExpression();
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        boolean maybeNode = th.relationship(itemType = operand.getItemType(), AnyNodeTest.getInstance()) != 4;
        boolean maybeAtomic = th.relationship(itemType, BuiltInAtomicType.ANY_ATOMIC) != 4;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        CastableExpressionCompiler.visitAnnotation(compiler, "CastableExpression-boolean");
        LabelInfo end = methodInfo.newLabel("endCastable");
        LabelInfo done = methodInfo.newLabel("doneCastable");
        LabelInfo zeroLab = methodInfo.newLabel("zeroLab");
        LabelInfo notNull = methodInfo.newLabel("notNullCastable");
        LabelInfo notInstance = methodInfo.newLabel("notInstanceCastable");
        LabelInfo notGTLab = methodInfo.newLabel("GTLab");
        LabelInfo GTLab2 = methodInfo.newLabel("GTLab2");
        compiler.compileToIterator(operand);
        int itrVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(itrVar);
        ga.push(0);
        int countVar = ga.newLocal(Type.INT_TYPE);
        ga.storeLocal(countVar);
        int atomicVar = methodInfo.allocateLocal(AtomicValue.class);
        LabelInfo loop = methodInfo.placeNewLabel("loop");
        ga.loadLocal(itrVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNonNull(notNull.label());
        ga.pop();
        ga.goTo(done);
        methodInfo.placeLabel(notNull);
        if (maybeNode) {
            ga.dup();
            ga.instanceOf(Type.getType(NodeInfo.class));
            ga.ifZCmp(153, notInstance.label());
            ga.checkClass(NodeInfo.class);
            ga.invokeInstanceMethod(NodeInfo.class, "atomize", new Class[0]);
            int atomizedValueVar = methodInfo.allocateLocal(AtomicSequence.class);
            ga.storeLocal(atomizedValueVar);
            ga.loadLocal(atomizedValueVar);
            ga.invokeInstanceMethod(AtomicSequence.class, "getLength", new Class[0]);
            int lenVar = ga.newLocal(Type.INT_TYPE);
            ga.storeLocal(lenVar);
            ga.loadLocal(countVar);
            ga.loadLocal(lenVar);
            ga.math(96, Type.INT_TYPE);
            ga.storeLocal(countVar);
            ga.loadLocal(countVar);
            ga.push(1);
            ga.ifICmp(158, notGTLab.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(notGTLab);
            ga.loadLocal(lenVar);
            ga.ifZCmp(153, loop.label());
            ga.loadLocal(atomizedValueVar);
            ga.push(0);
            ga.invokeInstanceMethod(AtomicSequence.class, "itemAt", Integer.TYPE);
            ga.checkClass(AtomicValue.class);
            ga.storeLocal(atomicVar);
            this.compileIsCastable(compiler, castableExpr, atomicVar);
            ga.ifZCmp(154, loop.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(notInstance);
            methodInfo.releaseLocal(atomizedValueVar);
        }
        if (maybeAtomic) {
            ga.checkClass(AtomicValue.class);
            ga.storeLocal(atomicVar);
            ga.loadLocal(countVar);
            ga.push(1);
            ga.math(96, Type.INT_TYPE);
            ga.storeLocal(countVar);
            ga.loadLocal(countVar);
            ga.push(1);
            ga.ifICmp(158, GTLab2.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(GTLab2);
            this.compileIsCastable(compiler, castableExpr, atomicVar);
            ga.ifZCmp(154, loop.label());
            ga.push(false);
            ga.goTo(end);
        } else {
            ga.pop();
        }
        ga.goTo(loop);
        methodInfo.placeLabel(done);
        if (castableExpr.allowsEmpty()) {
            ga.push(true);
            methodInfo.placeLabel(end);
            return;
        }
        ga.loadLocal(countVar);
        ga.ifZCmp(153, zeroLab.label());
        ga.push(true);
        ga.goTo(end);
        methodInfo.placeLabel(zeroLab);
        ga.push(false);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(itrVar);
        methodInfo.releaseLocal(atomicVar);
    }

    public void compileIsCastable(CompilerService compiler, CastableExpression castableExpr, int atomicVar) {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        Generator ga = compiler.getCurrentGenerator();
        Converter converter = castableExpr.getConverter();
        LabelInfo end = methodInfo.newLabel("endCastable");
        LabelInfo notSuccessful = methodInfo.newLabel("notSuccessful");
        if (converter == null) {
            ConversionRules conversionRules = compiler.getConfiguration().getConversionRules();
            ExpressionCompiler.allocateStatic(compiler, conversionRules);
            ga.loadLocal(atomicVar);
            ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
            CastableExpressionCompiler.allocateStatic(compiler, castableExpr.getTargetType());
            ga.invokeInstanceMethod(ConversionRules.class, "getConverter", AtomicType.class, AtomicType.class);
            int converterVar = methodInfo.allocateLocal(Converter.class);
            ga.storeLocal(converterVar);
            ga.loadLocal(converterVar);
            LabelInfo notNull1 = methodInfo.newLabel("notNull1");
            LabelInfo notLabel = methodInfo.newLabel("notLabel");
            ga.ifNonNull(notNull1.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(notNull1);
            ga.loadLocal(converterVar);
            ga.invokeInstanceMethod(Converter.class, "isAlwaysSuccessful", new Class[0]);
            ga.ifZCmp(153, notSuccessful.label());
            ga.push(true);
            ga.goTo(end);
            methodInfo.placeLabel(notSuccessful);
            if (castableExpr.getNamespaceResolver() != null) {
                ga.loadLocal(converterVar);
                CastableExpressionCompiler.allocateStatic(compiler, castableExpr.getNamespaceResolver());
                ga.invokeInstanceMethod(Converter.class, "setNamespaceResolver", NamespaceResolver.class);
                ga.storeLocal(converterVar);
            }
            ga.loadLocal(converterVar);
            methodInfo.releaseLocal(converterVar);
        } else {
            ExpressionCompiler.allocateStatic(compiler, converter);
        }
        ga.loadLocal(atomicVar);
        ga.invokeInstanceMethod(Converter.class, "convert", AtomicValue.class);
        ga.instanceOf(Type.getType(ValidationFailure.class));
        ga.not();
        methodInfo.placeLabel(end);
    }
}

