/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class VariableReferenceCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        VariableReferenceCompiler.visitAnnotation(compiler, "VariableReferenceCompiler-Iterator");
        VariableReferenceCompiler.genEvaluateVariable(compiler, ga, (VariableReference)expression);
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
    }

    public static void compileToSequence(CompilerService compiler, VariableReference expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        VariableReferenceCompiler.visitAnnotation(compiler, "VariableReferenceCompiler-Sequence");
        VariableReferenceCompiler.genEvaluateVariable(compiler, ga, expression);
    }

    public static void genEvaluateVariable(CompilerService compiler, Generator ga, VariableReference expression) {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        if (expression instanceof GlobalVariableReference) {
            GlobalVariableReference varRef = (GlobalVariableReference)expression;
            if (varRef.getBindingSlot() >= 0) {
                compiler.generateGetContext();
                ga.dup();
                ga.push(varRef.getBindingSlot());
                ga.invokeInstanceMethod(XPathContext.class, "getTargetComponent", Integer.TYPE);
                ga.dup();
                ga.invokeInstanceMethod(Component.class, "isHiddenAbstractComponent", new Class[0]);
                LabelInfo notAbstract = methodInfo.newLabel("notAbstract");
                ga.ifFalse(notAbstract);
                compiler.generateDynamicError("Cannot evaluate an abstract variable (" + varRef.getVariableName() + ") with no implementation", "XTDE3052", expression.getLocation(), false);
                ga.throwException();
                methodInfo.placeLabel(notAbstract);
                ga.dup();
                ga.invokeInstanceMethod(Component.class, "getActor", new Class[0]);
                ga.checkClass(GlobalVariable.class);
                ga.dupX2();
                ga.pop();
                ga.invokeInstanceMethod(GlobalVariable.class, "evaluateVariable", XPathContext.class, Component.class);
            } else {
                GlobalVariable var = (GlobalVariable)expression.getBinding();
                VariableReferenceCompiler.allocateStatic(compiler, var);
                compiler.generateGetContext();
                VariableReferenceCompiler.allocateStatic(compiler, var.getDeclaringComponent());
                ga.invokeInstanceMethod(GlobalVariable.class, "evaluateVariable", XPathContext.class, Component.class);
            }
        } else {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getStackFrame", new Class[0]);
            ga.invokeInstanceMethod(StackFrame.class, "getStackFrameValues", new Class[0]);
            ga.push(((LocalVariableReference)expression).getSlotNumber());
            ga.arrayLoad(Type.getType(Sequence.class));
        }
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        VariableReferenceCompiler.visitAnnotation(compiler, "VariableReferenceCompiler-Item");
        VariableReferenceCompiler.genEvaluateVariable(compiler, ga, (VariableReference)expression);
        ga.invokeInstanceMethod(Sequence.class, "head", new Class[0]);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        VariableReferenceCompiler.visitAnnotation(compiler, "VariableReferenceCompiler-Push");
        VariableReferenceCompiler.genEvaluateVariable(compiler, ga, (VariableReference)expression);
        int actualVar = methodInfo.allocateLocal(Sequence.class);
        ga.storeLocal(actualVar);
        LabelInfo done = methodInfo.newLabel("doneVarRef");
        ga.loadLocal(actualVar);
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
        int itrVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(itrVar);
        LabelInfo loop = methodInfo.placeNewLabel("loopVarRef");
        ga.loadLocal(itrVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(done.label());
        compiler.generateGetReceiver();
        ga.swap();
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class);
        ga.goTo(loop);
        methodInfo.placeLabel(done);
        ga.pop();
        methodInfo.releaseLocal(itrVar);
        methodInfo.releaseLocal(actualVar);
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        boolean dontKnow;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        Binding binding = ((VariableReference)expression).getBinding();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        VariableReferenceCompiler.visitAnnotation(compiler, "VariableReferenceCompiler-toBoolean");
        ItemType type = expression.getItemType();
        int rel = th.relationship(type, AnyNodeTest.getInstance());
        boolean isNode = rel == 0 || rel == 2;
        boolean isNotNode = rel == 4;
        boolean bl = dontKnow = !isNode && !isNotNode;
        if (Cardinality.allowsMany(expression.getCardinality()) || dontKnow) {
            super.compileToBoolean(compiler, expression);
        } else {
            VariableReferenceCompiler.genEvaluateVariable(compiler, ga, (VariableReference)expression);
            ga.invokeStaticMethod(SequenceTool.class, "asItem", Sequence.class);
            LabelInfo end = methodInfo.newLabel("end");
            if (Cardinality.allowsZero(expression.getCardinality())) {
                LabelInfo notNull = methodInfo.newLabel("notNull");
                ga.dup();
                ga.ifNonNull(notNull.label());
                ga.pop();
                ga.push(false);
                ga.goTo(end);
                methodInfo.placeLabel(notNull);
            }
            if (isNode) {
                ga.push(true);
            } else if (th.isSubType(type, BuiltInAtomicType.BOOLEAN)) {
                ga.checkClass(BooleanValue.class);
                ga.invokeInstanceMethod(BooleanValue.class, "getBooleanValue", new Class[0]);
            } else {
                ga.checkClass(AtomicValue.class);
                ga.invokeInstanceMethod(AtomicValue.class, "effectiveBooleanValue", new Class[0]);
            }
            methodInfo.placeLabel(end);
        }
    }
}

