/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.BooleanValue;

public class XSDAssert
extends AnnotationParent {
    private Assertion assertion = null;

    @Override
    public void prepareAttributes() throws SchemaException {
        XPathExpression condition;
        if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
            this.error("The xs:assert element requires XSD 1.1 to be enabled");
        }
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "test", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNamespace = atts.getValue("", "xpathDefaultNamespace");
        if (defaultNamespace == null) {
            defaultNamespace = this.getXSDSchema().getXPathDefaultNamespace();
        }
        if (defaultNamespace.equals("##defaultNamespace")) {
            defaultNamespace = this.getURIForPrefix("", true);
        } else if (defaultNamespace.equals("##targetNamespace")) {
            defaultNamespace = this.getXSDSchema().getTargetNamespace();
        } else if (defaultNamespace.equals("##local")) {
            defaultNamespace = "";
        }
        String xpath = atts.getValue("", "test");
        if (xpath == null) {
            this.missingAttribute("test");
            xpath = ".";
        }
        Configuration config = this.getConfiguration();
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(config);
        env.setDefaultElementNamespace(defaultNamespace);
        env.setNamespaceResolver(this.makeNamespaceContext());
        env.setBaseURI(this.getBaseURI());
        int xpathVersion = config.getConfigurationProperty(Feature.XPATH_VERSION_FOR_XSD);
        if (this.getXSDSchema().getAllowedExtensions().contains("any-xpath-version")) {
            xpathVersion = 31;
        }
        env.setXPathLanguageLevel(xpathVersion);
        XPathVariable valueVariable = env.declareVariable("", "value");
        HashMap<StructuredQName, XPathVariable> parameters = new HashMap<StructuredQName, XPathVariable>();
        for (GlobalParam param : this.getXSDSchema().getGlobalParams()) {
            XPathVariable var = env.declareVariable(param.getVariableQName());
            GroundedValue<?> defaultVal = ((Literal)param.getSelectExpression()).getValue();
            var.setDefaultValue(defaultVal);
            parameters.put(param.getVariableQName(), var);
        }
        boolean isComplex = this.getLocalPart().equals("assert");
        XPathEvaluator xpe = isComplex ? new CustomizedXPath(this.getConfiguration()) : new XPathEvaluator(this.getConfiguration());
        try {
            xpe.setStaticContext(env);
            condition = xpe.createExpression(xpath);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            try {
                condition = xpe.createExpression("false()");
            }
            catch (XPathException e2) {
                throw new AssertionError((Object)e2.getMessage());
            }
        }
        this.assertion = new Assertion(this.getSchema().getConfiguration(), condition, valueVariable, parameters, xpath);
        this.assertion.setStaticContext(env);
        String message = atts.getValue("http://saxon.sf.net/", "message");
        this.assertion.setMessage(message);
        this.processId();
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public static class CustomizedXPath
    extends XPathEvaluator {
        public CustomizedXPath(Configuration config) {
            super(config);
        }

        @Override
        protected Expression postProcess(Expression exp, ExpressionVisitor visitor, ContextItemStaticInfo cit) throws XPathException {
            Operand op;
            Expression core = exp;
            Operand lastOp = null;
            while (core instanceof LetExpression) {
                lastOp = ((LetExpression)core).getActionOp();
                core = lastOp.getChildExpression();
            }
            if (core instanceof QuantifiedExpression && ((QuantifiedExpression)core).getOperator() == 33) {
                QuantifiedExpression every = (QuantifiedExpression)core;
                if (every.getSequence().getItemType() instanceof NodeTest) {
                    Operand sequenceOp = every.getSequenceOp();
                    Operand satisfiesOp = every.getActionOp();
                    Expression satisfies = satisfiesOp.getChildExpression();
                    Expression[] conditions = new Expression[]{satisfies, Literal.makeLiteral(BooleanValue.TRUE)};
                    Expression[] actions = new Expression[]{Literal.makeEmptySequence(), new LocalVariableReference(every)};
                    Choose choose = new Choose(conditions, actions);
                    ForExpression forEx = new ForExpression();
                    forEx.setSequence(sequenceOp.getChildExpression());
                    forEx.setVariableQName(every.getVariableQName());
                    forEx.setAction(choose);
                    ExpressionTool.rebindVariableReferences(choose, every, forEx);
                    if (lastOp != null) {
                        lastOp.setChildExpression(forEx);
                        return exp.optimize(visitor, cit);
                    }
                    return forEx.optimize(visitor, cit);
                }
            } else if (core.isCallOn(Empty.class) && (op = ((SystemFunctionCall)core).getOperanda().getOperand(0)).getChildExpression().getItemType() instanceof NodeTest) {
                if (lastOp != null) {
                    lastOp.setChildExpression(op.getChildExpression());
                    return exp;
                }
                return op.getChildExpression();
            }
            Expression notExp = SystemFunction.makeCall("not", exp.getRetainedStaticContext(), exp);
            return new FilterExpression(new ContextItemExpression(), notExp);
        }
    }
}

