/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternThatSetsCurrent;
import net.sf.saxon.pattern.StreamingFunctionArgumentPattern;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.value.Cardinality;

public class VariableReferenceAdjunct
extends StreamingAdjunct {
    @Override
    public Pattern toStreamingPattern(Configuration config) {
        return StreamingFunctionArgumentPattern.getInstance();
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        VariableReference var = (VariableReference)this.getExpression();
        if (var instanceof LocalVariableReference) {
            LocalBinding binding = (LocalBinding)var.getBinding();
            if (binding instanceof LetExpression && ((LetExpression)binding).getSequence() instanceof ContextItemExpression) {
                ContextItemExpression cie = (ContextItemExpression)((LetExpression)binding).getSequence();
                if (Streamability.getPostureAndSweepIfKnown(cie) == null || Streamability.getPosture(cie) == Posture.GROUNDED) {
                    return new PostureAndSweep(Posture.GROUNDED, Sweep.MOTIONLESS);
                }
                Expression e = var;
                while (e != binding) {
                    Expression parent = e.getParentExpression();
                    for (Operand o : parent.operands()) {
                        if (o.getChildExpression() != e || !o.isEvaluatedRepeatedly()) continue;
                        return new PostureAndSweep(Posture.CLIMBING, Sweep.MOTIONLESS);
                    }
                    e = parent;
                }
                return Streamability.getPostureAndSweepIfKnown(cie);
            }
            if (binding instanceof LocalVariableBinding) {
                Expression e = var;
                Expression parent = e.getParentExpression();
                boolean inLoop = false;
                while (parent != null) {
                    if (!inLoop) {
                        for (Operand o : parent.operands()) {
                            if (o.getChildExpression() != e || !o.isEvaluatedRepeatedly()) continue;
                            inLoop = true;
                        }
                    }
                    if (inLoop && parent instanceof PatternThatSetsCurrent && ((PatternThatSetsCurrent)parent).getCurrentBinding() == binding) {
                        return new PostureAndSweep(Posture.CLIMBING, Sweep.MOTIONLESS);
                    }
                    e = parent;
                    parent = e.getParentExpression();
                }
            }
            if (binding instanceof UserFunctionParameter) {
                FunctionStreamability ability = ((UserFunctionParameter)binding).getFunctionStreamability();
                switch (ability) {
                    case ABSORBING: {
                        if (Cardinality.allowsMany(binding.getRequiredType().getCardinality())) {
                            return new PostureAndSweep(Posture.STRIDING, Sweep.CONSUMING);
                        }
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                    case ASCENT: {
                        if (Cardinality.allowsMany(binding.getRequiredType().getCardinality())) {
                            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
                        }
                        return new PostureAndSweep(Posture.CLIMBING, Sweep.MOTIONLESS);
                    }
                    case FILTER: {
                        if (Cardinality.allowsMany(binding.getRequiredType().getCardinality())) {
                            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
                        }
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                    case INSPECTION: {
                        if (Cardinality.allowsMany(binding.getRequiredType().getCardinality())) {
                            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
                        }
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                    case SHALLOW_DESCENT: {
                        if (Cardinality.allowsMany(binding.getRequiredType().getCardinality())) {
                            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
                        }
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                    case DEEP_DESCENT: {
                        if (Cardinality.allowsMany(binding.getRequiredType().getCardinality())) {
                            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
                        }
                        return new PostureAndSweep(Posture.STRIDING, Sweep.MOTIONLESS);
                    }
                }
                return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
            }
        }
        return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
    }
}

