/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.trans.Characteristic;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import com.saxonica.ee.trans.GeneralPatternOptimizer;
import com.saxonica.ee.trans.Precondition;
import com.saxonica.ee.trans.PreconditionMatcher;
import com.saxonica.ee.trans.RuleEE;
import com.saxonica.ee.trans.TemplateRuleEE;
import com.saxonica.trans.ModePE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleChain;
import net.sf.saxon.trans.rules.RuleSearchState;
import net.sf.saxon.trans.rules.RuleTarget;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;

public class ModeEE
extends ModePE {
    public ModeEE(StructuredQName modeName, CompilerInfo compilerInfo) {
        super(modeName);
        this.init();
    }

    private void init() {
    }

    @Override
    protected void exportUseAccumulators(ExpressionPresenter presenter) {
        Set<? extends Accumulator> accumulators = this.getAccumulators();
        if (accumulators != null && !accumulators.isEmpty()) {
            FastStringBuffer fsb = new FastStringBuffer(256);
            for (Accumulator accumulator : accumulators) {
                String name = accumulator.getAccumulatorName().getEQName();
                if (!fsb.isEmpty()) {
                    fsb.append(" ");
                }
                fsb.append(name);
            }
            presenter.emitAttribute("useAcc", fsb.toString());
        }
    }

    @Override
    public Rule makeRule(Pattern pattern, RuleTarget action, int precedence, int minImportPrecedence, double priority, int sequence, int part) {
        return new RuleEE(pattern, action, precedence, minImportPrecedence, priority, sequence, part);
    }

    @Override
    protected PreconditionMatcher makeRuleSearchState(RuleChain chain, XPathContext context) {
        return new PreconditionMatcher(chain, context);
    }

    public RuleChain getNamedNodeChain(NodeInfo node, XPathContext context) {
        if (node.hasFingerprint()) {
            switch (node.getNodeKind()) {
                case 1: {
                    return (RuleChain)this.namedElementRuleChains.get(node.getFingerprint());
                }
                case 2: {
                    return (RuleChain)this.namedAttributeRuleChains.get(node.getFingerprint());
                }
            }
        } else {
            switch (node.getNodeKind()) {
                case 1: 
                case 2: {
                    return this.getNamedRuleChain(context, node.getNodeKind(), node.getURI(), node.getLocalPart());
                }
            }
        }
        return null;
    }

    public RuleChain getUnnamedNodeChain(NodeInfo node) {
        switch (node.getNodeKind()) {
            case 9: {
                return this.documentRuleChain;
            }
            case 1: {
                return this.unnamedElementRuleChain;
            }
            case 2: {
                return this.unnamedAttributeRuleChain;
            }
            case 3: {
                return this.textRuleChain;
            }
            case 8: {
                return this.commentRuleChain;
            }
            case 7: {
                return this.processingInstructionRuleChain;
            }
            case 13: {
                return this.namespaceRuleChain;
            }
        }
        throw new AssertionError((Object)"Unknown node kind");
    }

    @Override
    protected boolean ruleMatches(Rule r, Item item, XPathContextMajor context, RuleSearchState ruleSearchState) throws XPathException {
        return r.isAlwaysMatches() || ((RuleEE)r).checkPreconditions((PreconditionMatcher)ruleSearchState) && r.matches(item, context);
    }

    @Override
    public void computeStreamability() throws XPathException {
        Mode.RuleAction action = r -> {
            TemplateRuleEE t = (TemplateRuleEE)r.getAction();
            ArrayList<String> reasons = new ArrayList<String>();
            PostureAndSweep ps = Streamability.getStreamability(t.getBody(), ContextItemStaticInfoEE.DEFAULT, reasons);
            if (ps.getSweep() == Sweep.FREE_RANGING || ps.getPosture() == Posture.ROAMING) {
                StringBuilder message = new StringBuilder("Stylesheet packaging problem: reloaded template with match = " + t.getMatchPattern().toShortString() + " is not streamable. ");
                for (String reason : reasons) {
                    message.append(reason).append(". ");
                }
                throw new XPathException(message.toString());
            }
        };
        this.processRules(action);
    }

    @Override
    public void invertStreamableTemplates() throws XPathException {
        if (this.isDeclaredStreamable()) {
            Mode.RuleAction check = r -> {
                TemplateRuleEE t = (TemplateRuleEE)r.getAction();
                if (t.getBody() != null) {
                    if (Streamability.getPostureAndSweepIfKnown(t.getBody()) == null && !t.isActuallyStreamable(new ArrayList<String>())) {
                        throw new XPathException("Template rule is not streamable", "XTSE3430", t);
                    }
                    if (!t.isDeclaredStreamable()) {
                        this.setStreamable(false);
                    }
                }
            };
            this.processRules(check);
        }
        if (this.isDeclaredStreamable()) {
            this.processRules(r -> {
                TemplateRuleEE t = (TemplateRuleEE)r.getAction();
                if (t.getBody() != null && Streamability.getSweep(t.getBody()) == Sweep.CONSUMING) {
                    t.makeInversion();
                }
            });
        }
    }

    protected RuleTypeAction setType(RuleTypeAction action, ItemType type) {
        action.setType(type);
        return action;
    }

    @Override
    public void optimizeRules() {
        this.optimizeRuleChain(this.documentRuleChain);
        this.optimizeRuleChain(this.unnamedElementRuleChain);
        for (RuleChain chain : this.namedElementRuleChains.valueSet()) {
            this.optimizeRuleChain(chain);
        }
        this.optimizeRuleChain(this.unnamedAttributeRuleChain);
        for (RuleChain chain : this.namedAttributeRuleChains.valueSet()) {
            this.optimizeRuleChain(chain);
        }
        this.optimizeRuleChain(this.textRuleChain);
        this.optimizeRuleChain(this.commentRuleChain);
        this.optimizeRuleChain(this.processingInstructionRuleChain);
        this.optimizeRuleChain(this.namespaceRuleChain);
        this.optimizeRuleChain(this.genericRuleChain);
        this.optimizeRuleChain(this.atomicValueRuleChain);
        this.optimizeRuleChain(this.functionItemRuleChain);
    }

    public void optimizeRuleChain(RuleChain chain) {
        if (chain.getLength() >= 10) {
            Map<Precondition, List<RuleEE>> preconditions = new HashMap<Precondition, List<RuleEE>>();
            HashMap<Characteristic, Characteristic> characteristics = new HashMap<Characteristic, Characteristic>();
            for (Rule r = chain.head(); r != null; r = r.getNext()) {
                this.computeCandidatePreconditions((RuleEE)r, preconditions, characteristics);
            }
            if ((preconditions = this.filterPreconditions(chain, preconditions)).size() > 4 || characteristics.size() > 4) {
                this.allocatePreconditionSlots(preconditions);
                this.allocateCharacteristicSlots(characteristics);
                RuleChainOptimizationData data = new RuleChainOptimizationData();
                data.preconditions = preconditions;
                data.characteristics = characteristics.keySet();
                chain.optimizationData = data;
            }
        }
    }

    private void computeCandidatePreconditions(RuleEE rule, Map<Precondition, List<RuleEE>> preconditions, Map<Characteristic, Characteristic> characteristics) {
        Pattern pattern = rule.getPattern();
        GeneralPatternOptimizer.getInstance().process(rule, pattern, preconditions, characteristics);
    }

    private Map<Precondition, List<RuleEE>> filterPreconditions(RuleChain chain, Map<Precondition, List<RuleEE>> candidates) {
        HashMap<Precondition, List<RuleEE>> result = new HashMap<Precondition, List<RuleEE>>();
        int chainLength = chain.getLength();
        for (Map.Entry<Precondition, List<RuleEE>> entry : candidates.entrySet()) {
            int numRules = entry.getValue().size();
            if (numRules < 3 || numRules > chainLength - 3) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private void allocatePreconditionSlots(Map<Precondition, List<RuleEE>> conditions) {
        int slot = 0;
        for (Map.Entry<Precondition, List<RuleEE>> entry : conditions.entrySet()) {
            entry.getKey().setSlotNumber(slot++);
            for (RuleEE rule : entry.getValue()) {
                rule.addPrecondition(entry.getKey());
            }
        }
    }

    private void allocateCharacteristicSlots(Map<Characteristic, Characteristic> characteristics) {
        int slot = 0;
        for (Characteristic chic : characteristics.keySet()) {
            chic.setSlotNumber(slot++);
        }
    }

    public static List<Rule> listRules(RuleChain chain) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule r = chain == null ? null : chain.head(); r != null; r = r.getNext()) {
            result.add(r);
        }
        return result;
    }

    public static List<Rule> orderRules(List<Rule> r1, List<Rule> r2) {
        Rule chain2;
        ArrayList<Rule> result = new ArrayList<Rule>();
        Iterator<Rule> ir1 = r1.iterator();
        Iterator<Rule> ir2 = r2.iterator();
        Rule chain1 = ir1.hasNext() ? ir1.next() : null;
        Rule rule = chain2 = ir2.hasNext() ? ir2.next() : null;
        while (chain1 != null || chain2 != null) {
            if (ModeEE.useFirst(chain1, chain2)) {
                result.add(chain1);
                chain1 = ir1.hasNext() ? ir1.next() : null;
                continue;
            }
            result.add(chain2);
            chain2 = ir2.hasNext() ? ir2.next() : null;
        }
        return result;
    }

    protected static boolean useFirst(Rule chain1, Rule chain2) {
        if (chain1 == null) {
            return false;
        }
        if (chain2 == null) {
            return true;
        }
        int rank = chain1.compareRank(chain2);
        if (rank > 0) {
            return true;
        }
        if (rank == 0) {
            return chain1.getSequence() >= chain2.getSequence();
        }
        return false;
    }

    public static List<Rule> orderRules(RuleChain chain1, RuleChain chain2) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        Rule r1 = chain1.head();
        Rule r2 = chain2.head();
        while (r1 != null || r2 != null) {
            if (ModeEE.useFirst(r1, r2)) {
                result.add(r1);
                r1 = r1.getNext();
                continue;
            }
            result.add(r2);
            r2 = r2.getNext();
        }
        return result;
    }

    @Override
    public void explainTemplateRules(ExpressionPresenter out) throws XPathException {
        super.explainTemplateRules(out);
    }

    @Override
    public void reportAmbiguity(Item item, Rule r1, Rule r2, XPathContext c) throws XPathException {
        super.reportAmbiguity(item, r1, r2, c);
    }

    public static String typeName(int type) {
        switch (type) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "element()";
            }
            case 2: {
                return "attribute()";
            }
            case 3: {
                return "text()";
            }
            case 8: {
                return "comment()";
            }
            case 7: {
                return "processing-instruction()";
            }
            case 13: {
                return "namespace-node()";
            }
        }
        return "";
    }

    public static class RuleChainOptimizationData {
        public Map<Precondition, List<RuleEE>> preconditions;
        public Set<Characteristic> characteristics;
    }

    public static interface RuleTypeAction
    extends Mode.RuleAction {
        public void setType(ItemType var1);
    }
}

