/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.exslt;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.YearMonthDurationValue;

public final class Date {
    private Date() {
    }

    public static String dateTime(XPathContext context) throws XPathException {
        return context.getCurrentDateTime().getStringValue();
    }

    public static String date(XPathContext context, String datetimeIn) {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        if ((datetimeIn = Date.nn(datetimeIn)).indexOf(84) >= 0) {
            ConversionResult cr = DateTimeValue.makeDateTimeValue(datetimeIn, rules);
            if (cr instanceof ValidationFailure) {
                return "";
            }
            return ((DateTimeValue)cr).toDateValue().getStringValue();
        }
        ConversionResult cr = DateValue.makeDateValue(datetimeIn, rules);
        if (cr instanceof ValidationFailure) {
            return "";
        }
        return ((AtomicValue)cr).getStringValue();
    }

    public static String date(XPathContext context) throws XPathException {
        return Date.date(context, Date.dateTime(context));
    }

    public static String time(XPathContext context, String dateTime) {
        if ((dateTime = Date.nn(dateTime)).indexOf(84) >= 0) {
            ConversionResult cr = DateTimeValue.makeDateTimeValue(dateTime, context.getConfiguration().getConversionRules());
            if (cr instanceof ValidationFailure) {
                return "";
            }
            return ((DateTimeValue)cr).toTimeValue().getStringValue();
        }
        ConversionResult cr = TimeValue.makeTimeValue(dateTime);
        if (cr instanceof ValidationFailure) {
            return "";
        }
        return ((AtomicValue)cr).getStringValue();
    }

    public static String time(XPathContext context) throws XPathException {
        return Date.time(context, Date.dateTime(context));
    }

    public static double year(XPathContext context, String datetimeIn) {
        datetimeIn = Date.nn(datetimeIn);
        try {
            ConversionResult cr = CalendarValue.makeCalendarValue(datetimeIn, context.getConfiguration().getConversionRules());
            if (cr instanceof ValidationFailure) {
                return Double.NaN;
            }
            if (cr instanceof GMonthValue || cr instanceof GMonthDayValue || cr instanceof GDayValue || cr instanceof TimeValue) {
                return Double.NaN;
            }
            AtomicValue year = ((CalendarValue)cr).getComponent(AccessorFn.Component.YEAR);
            return ((NumericValue)year).getDoubleValue();
        }
        catch (XPathException e) {
            return Double.NaN;
        }
    }

    public static double year(XPathContext context) throws XPathException {
        return Date.year(context, Date.dateTime(context));
    }

    public static boolean leapYear(XPathContext context, String dateTime) {
        double year = Date.year(context, dateTime = Date.nn(dateTime));
        if (Double.isNaN(year)) {
            return false;
        }
        int y = (int)year;
        return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0);
    }

    public static boolean leapYear(XPathContext context) throws XPathException {
        return Date.leapYear(context, Date.dateTime(context));
    }

    public static double monthInYear(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        try {
            ConversionResult cr = CalendarValue.makeCalendarValue(dateTime, context.getConfiguration().getConversionRules());
            if (cr instanceof ValidationFailure) {
                return Double.NaN;
            }
            if (cr instanceof GYearValue || cr instanceof GDayValue || cr instanceof TimeValue) {
                return Double.NaN;
            }
            AtomicValue month = ((CalendarValue)cr).getComponent(AccessorFn.Component.MONTH);
            return ((NumericValue)month).getDoubleValue();
        }
        catch (XPathException e) {
            return Double.NaN;
        }
    }

    public static double monthInYear(XPathContext context) throws XPathException {
        return Date.monthInYear(context, Date.dateTime(context));
    }

    public static String monthName(XPathContext context, String date) {
        date = Date.nn(date);
        String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        double m = Date.monthInYear(context, date);
        if (Double.isNaN(m)) {
            return "";
        }
        return months[(int)m - 1];
    }

    public static String monthName(XPathContext context) throws XPathException {
        return Date.monthName(context, Date.dateTime(context));
    }

    public static String monthAbbreviation(XPathContext context, String date) {
        date = Date.nn(date);
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        double m = Date.monthInYear(context, date);
        if (Double.isNaN(m)) {
            return "";
        }
        return months[(int)m - 1];
    }

    public static String monthAbbreviation(XPathContext context) throws XPathException {
        return Date.monthAbbreviation(context, Date.dateTime(context));
    }

    public static double weekInYear(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        int dayInYear = (int)Date.dayInYear(context, dateTime);
        String firstJan = dateTime.substring(0, 4) + "-01-01";
        int jan1day = ((int)Date.dayInWeek(context, firstJan) + 5) % 7;
        int daysInFirstWeek = jan1day == 0 ? 0 : 7 - jan1day;
        int rawWeek = (dayInYear - daysInFirstWeek + 6) / 7;
        if (daysInFirstWeek >= 4) {
            return rawWeek + 1;
        }
        if (rawWeek > 0) {
            return rawWeek;
        }
        int lastYear = Integer.parseInt(dateTime.substring(0, 4)) - 1;
        String dec31 = lastYear + "-12-31";
        return Date.weekInYear(context, dec31);
    }

    public static double weekInYear(XPathContext context) throws XPathException {
        return Date.weekInYear(context, Date.dateTime(context));
    }

    public static double weekInMonth(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        return (int)((Date.dayInMonth(context, dateTime) - 1.0) / 7.0 + 1.0);
    }

    public static double weekInMonth(XPathContext context) throws XPathException {
        return Date.weekInMonth(context, Date.dateTime(context));
    }

    public static double dayInYear(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        int month = (int)Date.monthInYear(context, dateTime);
        int day = (int)Date.dayInMonth(context, dateTime);
        int[] prev = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        int leap = month > 2 && Date.leapYear(context, dateTime) ? 1 : 0;
        return prev[month - 1] + leap + day;
    }

    public static double dayInYear(XPathContext context) throws XPathException {
        return Date.dayInYear(context, Date.dateTime(context));
    }

    public static double dayInMonth(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        try {
            ConversionResult cr = CalendarValue.makeCalendarValue(dateTime, context.getConfiguration().getConversionRules());
            if (cr instanceof ValidationFailure) {
                return Double.NaN;
            }
            if (cr instanceof GYearValue || cr instanceof GYearMonthValue || cr instanceof GMonthValue || cr instanceof TimeValue) {
                return Double.NaN;
            }
            AtomicValue day = ((CalendarValue)cr).getComponent(AccessorFn.Component.DAY);
            return ((NumericValue)day).getDoubleValue();
        }
        catch (XPathException e) {
            return Double.NaN;
        }
    }

    public static double dayInMonth(XPathContext context) throws XPathException {
        return Date.dayInMonth(context, Date.dateTime(context));
    }

    public static double dayOfWeekInMonth(XPathContext context, String dateTime) {
        double dd = Date.dayInMonth(context, dateTime = Date.nn(dateTime));
        if (Double.isNaN(dd)) {
            return dd;
        }
        return ((int)dd - 1) / 7 + 1;
    }

    public static double dayOfWeekInMonth(XPathContext context) throws XPathException {
        return Date.dayOfWeekInMonth(context, Date.dateTime(context));
    }

    public static double dayInWeek(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        double yy = Date.year(context, dateTime);
        double mm = Date.monthInYear(context, dateTime);
        double dd = Date.dayInMonth(context, dateTime);
        if (Double.isNaN(yy) || Double.isNaN(mm) || Double.isNaN(dd)) {
            return Double.NaN;
        }
        GregorianCalendar calDate = new GregorianCalendar((int)yy, (int)mm - 1, (int)dd);
        calDate.setFirstDayOfWeek(1);
        return calDate.get(7);
    }

    public static double dayInWeek(XPathContext context) throws XPathException {
        return Date.dayInWeek(context, Date.dateTime(context));
    }

    public static String dayName(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        double d = Date.dayInWeek(context, dateTime);
        if (Double.isNaN(d)) {
            return "";
        }
        return days[(int)d - 1];
    }

    public static String dayName(XPathContext context) throws XPathException {
        return Date.dayName(context, Date.dateTime(context));
    }

    public static String dayAbbreviation(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        double d = Date.dayInWeek(context, dateTime);
        if (Double.isNaN(d)) {
            return "";
        }
        return days[(int)d - 1];
    }

    public static String dayAbbreviation(XPathContext context) throws XPathException {
        return Date.dayAbbreviation(context, Date.dateTime(context));
    }

    public static double hourInDay(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        try {
            ConversionResult cr = CalendarValue.makeCalendarValue(dateTime, context.getConfiguration().getConversionRules());
            if (cr instanceof ValidationFailure) {
                return Double.NaN;
            }
            if (!(cr instanceof DateTimeValue) && !(cr instanceof TimeValue)) {
                return Double.NaN;
            }
            AtomicValue hour = ((CalendarValue)cr).getComponent(AccessorFn.Component.HOURS);
            return ((NumericValue)hour).getDoubleValue();
        }
        catch (XPathException e) {
            return Double.NaN;
        }
    }

    public static double hourInDay(XPathContext context) throws XPathException {
        return Date.hourInDay(context, Date.dateTime(context));
    }

    public static double minuteInHour(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        try {
            ConversionResult cr = CalendarValue.makeCalendarValue(dateTime, context.getConfiguration().getConversionRules());
            if (cr instanceof ValidationFailure) {
                return Double.NaN;
            }
            if (!(cr instanceof DateTimeValue) && !(cr instanceof TimeValue)) {
                return Double.NaN;
            }
            AtomicValue minute = ((CalendarValue)cr).getComponent(AccessorFn.Component.MINUTES);
            return ((NumericValue)minute).getDoubleValue();
        }
        catch (XPathException e) {
            return Double.NaN;
        }
    }

    public static double minuteInHour(XPathContext context) throws XPathException {
        return Date.minuteInHour(context, Date.dateTime(context));
    }

    public static double secondInMinute(XPathContext context, String dateTime) {
        dateTime = Date.nn(dateTime);
        try {
            ConversionResult cr = CalendarValue.makeCalendarValue(dateTime, context.getConfiguration().getConversionRules());
            if (cr instanceof ValidationFailure) {
                return Double.NaN;
            }
            if (!(cr instanceof DateTimeValue) && !(cr instanceof TimeValue)) {
                return Double.NaN;
            }
            AtomicValue second = ((CalendarValue)cr).getComponent(AccessorFn.Component.SECONDS);
            return ((NumericValue)second).getDoubleValue();
        }
        catch (XPathException e) {
            return Double.NaN;
        }
    }

    public static double secondInMinute(XPathContext context) throws XPathException {
        return Date.secondInMinute(context, Date.dateTime(context));
    }

    public static String add(XPathContext context, String datetimeIn, String durationIn) throws XPathException {
        datetimeIn = Date.nn(datetimeIn);
        durationIn = Date.nn(durationIn);
        ConversionResult cr0 = CalendarValue.makeCalendarValue(datetimeIn, context.getConfiguration().getConversionRules());
        if (cr0 instanceof ValidationFailure) {
            return "";
        }
        CalendarValue cv0 = (CalendarValue)cr0;
        if (Date.specificity(cv0) < 0) {
            return "";
        }
        DateTimeValue v0 = cv0.toDateTime();
        ConversionResult cr1 = DurationValue.makeDuration(durationIn);
        if (cr1 instanceof ValidationFailure) {
            return "";
        }
        DurationValue v1 = (DurationValue)cr1;
        YearMonthDurationValue v1m = Converter.DurationToYearMonthDuration.INSTANCE.convert(v1);
        DayTimeDurationValue v1s = Converter.DurationToDayTimeDuration.INSTANCE.convert(v1);
        DateTimeValue sum = v0.add(v1m).add(v1s);
        return Converter.convert(sum, cv0.getPrimitiveType(), context.getConfiguration().getConversionRules()).getStringValue();
    }

    public static String sum(SequenceIterator durations) throws XPathException {
        Object it;
        DurationValue tot = (DurationValue)DurationValue.makeDuration("PT0S");
        while ((it = durations.next()) != null) {
            ConversionResult cr = DurationValue.makeDuration(it.getStringValueCS());
            if (cr instanceof ValidationFailure) {
                return "";
            }
            if ((tot = Date.addDurationValues(tot, (DurationValue)cr)) != null) continue;
            return "";
        }
        return tot.getStringValue();
    }

    public String addDuration(String duration0, String duration1) {
        duration0 = Date.nn(duration0);
        duration1 = Date.nn(duration1);
        ConversionResult dv0 = DurationValue.makeDuration(duration0);
        ConversionResult dv1 = DurationValue.makeDuration(duration1);
        if (dv0 instanceof ValidationFailure || dv1 instanceof ValidationFailure) {
            return "";
        }
        DurationValue result = Date.addDurationValues((DurationValue)dv0, (DurationValue)dv1);
        return result == null ? "" : result.getStringValue();
    }

    private static DurationValue addDurationValues(DurationValue dv0, DurationValue dv1) {
        boolean positive;
        YearMonthDurationValue dv0m = Converter.DurationToYearMonthDuration.INSTANCE.convert(dv0);
        DayTimeDurationValue dv0s = Converter.DurationToDayTimeDuration.INSTANCE.convert(dv0);
        YearMonthDurationValue dv1m = Converter.DurationToYearMonthDuration.INSTANCE.convert(dv1);
        DayTimeDurationValue dv1s = Converter.DurationToDayTimeDuration.INSTANCE.convert(dv1);
        int months = dv0m.getLengthInMonths() + dv1m.getLengthInMonths();
        long micros = dv0s.getLengthInMicroseconds() + dv1s.getLengthInMicroseconds();
        if (Integer.signum(months) * Long.signum(micros) < 0) {
            return null;
        }
        boolean bl = positive = months >= 0 && micros >= 0L;
        if (!positive) {
            months = -months;
            micros = -micros;
        }
        return new DurationValue(positive, 0, months, 0, 0, 0, (int)(micros / 1000000L), (int)(micros % 1000000L), BuiltInAtomicType.DURATION);
    }

    public static String difference(XPathContext context, String dateLeftIn, String dateRightIn) {
        try {
            dateLeftIn = Date.nn(dateLeftIn);
            dateRightIn = Date.nn(dateRightIn);
            ConversionRules rules = context.getConfiguration().getConversionRules();
            ConversionResult op0 = CalendarValue.makeCalendarValue(dateLeftIn, rules);
            ConversionResult op1 = CalendarValue.makeCalendarValue(dateRightIn, rules);
            if (op0 instanceof ValidationFailure || op1 instanceof ValidationFailure) {
                return "";
            }
            CalendarValue v0 = (CalendarValue)op0;
            CalendarValue v1 = (CalendarValue)op1;
            int s0 = Date.specificity(v0);
            int s1 = Date.specificity(v1);
            if (s0 < 0 || s1 < 0) {
                return "";
            }
            if (s0 < s1) {
                v1 = (CalendarValue)Converter.convert(v1, v0.getPrimitiveType(), rules);
            } else if (s1 < s0) {
                v0 = (CalendarValue)Converter.convert(v0, v1.getPrimitiveType(), rules);
            }
            if (v0 instanceof GYearValue) {
                int y0 = ((GYearValue)v0).getYear();
                int y1 = ((GYearValue)v1).getYear();
                return YearMonthDurationValue.fromMonths(12 * (y1 - y0)).getStringValue();
            }
            if (v0 instanceof GYearMonthValue) {
                int y0 = ((GYearMonthValue)v0).getYear();
                int y1 = ((GYearMonthValue)v1).getYear();
                byte m0 = ((GYearMonthValue)v0).getMonth();
                byte m1 = ((GYearMonthValue)v1).getMonth();
                return YearMonthDurationValue.fromMonths(12 * (y1 - y0) + (m1 - m0)).getStringValue();
            }
            DateTimeValue dt0 = v0.toDateTime();
            DateTimeValue dt1 = v1.toDateTime();
            return dt1.subtract(dt0, context).getStringValue();
        }
        catch (XPathException e) {
            return "";
        }
    }

    private static int specificity(CalendarValue val) {
        if (val instanceof GYearValue) {
            return 0;
        }
        if (val instanceof GYearMonthValue) {
            return 1;
        }
        if (val instanceof DateValue) {
            return 2;
        }
        if (val instanceof DateTimeValue) {
            return 3;
        }
        return -1;
    }

    public static String duration(double seconds) {
        DayTimeDurationValue v = DayTimeDurationValue.fromSeconds(new BigDecimal(seconds));
        return v.getStringValue();
    }

    public static double seconds(XPathContext context) throws XPathException {
        DateTimeValue now = context.getCurrentDateTime();
        DayTimeDurationValue diff = now.subtract(DateTimeValue.EPOCH, context);
        return ((DurationValue)diff).getLengthInSeconds();
    }

    public static double seconds(XPathContext context, String datetimeIn) {
        try {
            datetimeIn = Date.nn(datetimeIn);
            ConversionResult cr = CalendarValue.makeCalendarValue(datetimeIn, context.getConfiguration().getConversionRules());
            if (cr instanceof DateTimeValue || cr instanceof DateValue || cr instanceof GYearValue || cr instanceof GYearMonthValue) {
                DateTimeValue dateTime = ((CalendarValue)cr).toDateTime();
                DayTimeDurationValue diff = dateTime.subtract(DateTimeValue.EPOCH, context);
                return diff.getLengthInSeconds();
            }
            cr = DurationValue.makeDuration(datetimeIn);
            if (cr instanceof DurationValue) {
                DurationValue duration = (DurationValue)cr;
                if (duration.getYears() != 0 || duration.getMonths() != 0) {
                    return Double.NaN;
                }
                return duration.getLengthInSeconds();
            }
            return Double.NaN;
        }
        catch (XPathException e) {
            return Double.NaN;
        }
    }

    private static String nn(String in) {
        return in == null ? "" : in;
    }
}

