/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper;

import java.util.LinkedList;
import java.util.List;
import marmot.morph.mapper.MorphTag;
import marmot.morph.mapper.SyntaxTree;

public class Node {
    private String form_;
    private String lemma_;
    private String pos_;
    private String feats_;
    private String deprel_;
    private int head_;
    private SyntaxTree tree_;
    private MorphTag tag_;

    public String getForm() {
        return this.form_;
    }

    public String getLemma() {
        return this.lemma_;
    }

    public String getDeprel() {
        return this.deprel_;
    }

    public String getPos() {
        return this.pos_;
    }

    public String getFeats() {
        return this.feats_;
    }

    public Node(String form, String lemma, String pos, String feats, int head, String deprel, SyntaxTree tree) {
        this.form_ = form;
        this.lemma_ = lemma;
        this.pos_ = pos;
        this.feats_ = feats;
        this.deprel_ = deprel;
        this.head_ = head;
        this.tree_ = tree;
    }

    public Node getHead() {
        if (this.head_ == 0) {
            return null;
        }
        return this.tree_.getNodes().get(this.head_ - 1);
    }

    public List<Node> getChildren() {
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Node node : this.tree_.getNodes()) {
            if (node.getHead() != this) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public void setMorphTag(MorphTag tag) {
        this.tag_ = tag;
    }

    public MorphTag getMorphTag() {
        return this.tag_;
    }

    public int getHeadIndex() {
        return this.head_;
    }

    public String toString() {
        return this.form_;
    }

    public void setForm(String form) {
        this.form_ = form;
    }

    public void setLemma(String lemma) {
        this.lemma_ = lemma;
    }

    public void setDeprel(String deprel) {
        this.deprel_ = deprel;
    }
}

