/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import marmot.util.LineIterator;

public class ConllLineIterator
extends LineIterator {
    private static final String DefaultSeperator_ = "\\t";

    public ConllLineIterator(String filename) {
        super(filename, DefaultSeperator_);
    }

    public ConllLineIterator(InputStream in) {
        super(in, DefaultSeperator_);
    }

    @Override
    public List<String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            String line = this.reader_.readLine();
            if (line.length() > 1 && line.charAt(0) == '#') {
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(line);
                return list;
            }
            String[] tokens = line.split(this.seperator_);
            if (tokens[0].contains(".")) {
                ArrayList<String> list = new ArrayList<String>(1);
                String[] idxTok = tokens[0].split(".");
                list.add("$|$" + idxTok[0] + "$|$" + line);
                list.add(line);
                return list;
            }
            if (tokens[0].contains("-")) {
                String[] idxTok = tokens[0].split("-");
                ArrayList<String> list = new ArrayList<String>(1);
                list.add("|$|" + idxTok[0] + "|$|" + line);
                list.add(line);
                return list;
            }
            ArrayList<String> list = new ArrayList<String>(tokens.length);
            for (String token2 : tokens) {
                if (token2.isEmpty()) continue;
                list.add(token2);
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e);
        }
    }
}

