/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import opennlp.tools.ml.model.DataReader;
import opennlp.tools.ml.model.ModelParameterChunker;

public class BinaryFileDataReader
implements DataReader {
    private final DataInputStream input;

    public BinaryFileDataReader(File f) throws IOException {
        this.input = f.getName().endsWith(".gz") ? new DataInputStream(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))))) : new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
    }

    public BinaryFileDataReader(InputStream in) {
        this(new DataInputStream(in));
    }

    public BinaryFileDataReader(DataInputStream in) {
        this.input = in;
    }

    @Override
    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    @Override
    public int readInt() throws IOException {
        return this.input.readInt();
    }

    @Override
    public String readUTF() throws IOException {
        return ModelParameterChunker.readUTF(this.input);
    }
}

