/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPoolReportingAsynchronousRunner;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.SQLWarnings;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractC3P0PooledConnection;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.ConnectionTestPath;
import com.mchange.v2.c3p0.impl.ConnectionTesterConnectionTestPath;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.c3p0.impl.IsValidSimplifiedConnectionTestPath;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    private static final boolean ASYNCHRONOUS_CONNECTION_EVENT_LISTENER = false;
    static final MLogger logger = MLog.getLogger(C3P0PooledConnectionPool.class);
    final ResourcePool rp;
    final ConnectionEventListener cl = new ConnectionEventListenerImpl();
    final ConnectionTester connectionTester;
    final GooGooStatementCache scache;
    final Resurrectables resurrectables;
    final boolean c3p0PooledConnections;
    final int checkoutTimeout;
    final int connectionIsValidTimeout;
    final AsynchronousRunner sharedTaskRunner;
    final AsynchronousRunner deferredStatementDestroyer;
    final InUseLockFetcher inUseLockFetcher;
    private RequestBoundaryMarker requestBoundaryMarker;
    private static InUseLockFetcher RESOURCE_ITSELF_IN_USE_LOCK_FETCHER = new ResourceItselfInUseLockFetcher();
    private static InUseLockFetcher C3P0_POOLED_CONNECION_NESTED_LOCK_LOCK_FETCHER = new C3P0PooledConnectionNestedLockLockFetcher();
    private static RequestBoundaryMarker NO_OP_REQUEST_BOUNDARY_MARKER = new NoOpRequestBoundaryMarker();

    public int getStatementDestroyerNumConnectionsInUse() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumConnectionsInUse();
    }

    public int getStatementDestroyerNumConnectionsWithDeferredDestroyStatements() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumConnectionsWithDeferredDestroyStatements();
    }

    public int getStatementDestroyerNumDeferredDestroyStatements() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumDeferredDestroyStatements();
    }

    private synchronized RequestBoundaryMarker findRequestBoundaryMarker(PooledConnection pooledConnection) {
        if (this.requestBoundaryMarker != null) {
            return this.requestBoundaryMarker;
        }
        if (pooledConnection instanceof AbstractC3P0PooledConnection) {
            AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
            Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
            try {
                Method method;
                Method method2 = connection.getClass().getMethod("beginRequest", new Class[0]);
                if (!method2.isAccessible()) {
                    method2.setAccessible(true);
                }
                if (!(method = connection.getClass().getMethod("endRequest", new Class[0])).isAccessible()) {
                    method.setAccessible(true);
                }
                logger.log(MLevel.FINEST, "Request boundary methods found");
                this.requestBoundaryMarker = new LiveRequestBoundaryMarker();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.log(MLevel.WARNING, "Request boundary methods not found.");
                this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
            }
            catch (SecurityException securityException) {
                logger.log(MLevel.WARNING, "Could not make boundary methods accessible.");
                this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
            }
        } else {
            this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
        }
        return this.requestBoundaryMarker;
    }

    private void markBeginRequest(PooledConnection pooledConnection) {
        this.findRequestBoundaryMarker(pooledConnection).attemptNotifyBeginRequest(pooledConnection);
    }

    private void markEndRequest(PooledConnection pooledConnection) {
        this.findRequestBoundaryMarker(pooledConnection).attemptNotifyEndRequest(pooledConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(final ConnectionPoolDataSource connectionPoolDataSource, final DbAuth dbAuth, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, final int n8, int n9, int n10, int n11, int n12, int n13, int n14, boolean bl2, boolean bl3, final boolean bl4, final boolean bl5, boolean bl6, int n15, int n16, final ConnectionTester connectionTester, final ConnectionCustomizer connectionCustomizer, final String string, ResourcePoolFactory resourcePoolFactory, ThreadPoolReportingAsynchronousRunner threadPoolReportingAsynchronousRunner, ThreadPoolReportingAsynchronousRunner threadPoolReportingAsynchronousRunner2, final String string2) throws SQLException {
        try {
            this.c3p0PooledConnections = connectionPoolDataSource instanceof WrapperConnectionPoolDataSource;
            if (!this.c3p0PooledConnections) {
                if (logger.isLoggable(MLevel.WARNING) && (n15 > 0 || n16 > 0)) {
                    logger.log(MLevel.WARNING, "Statement caching is configured, but cannot be supported, because the provided ConnectionPoolDataSource is not a c3p0 implementation. Initializing with no statement cache.");
                }
                this.scache = null;
            } else {
                this.scache = n15 > 0 && n16 > 0 ? new DoubleMaxStatementCache(threadPoolReportingAsynchronousRunner, threadPoolReportingAsynchronousRunner2, n15, n16) : (n16 > 0 ? new PerConnectionMaxOnlyStatementCache(threadPoolReportingAsynchronousRunner, threadPoolReportingAsynchronousRunner2, n16) : (n15 > 0 ? new GlobalMaxOnlyStatementCache(threadPoolReportingAsynchronousRunner, threadPoolReportingAsynchronousRunner2, n15) : null));
            }
            this.resurrectables = bl6 ? new Resurrectables() : null;
            this.connectionTester = connectionTester;
            this.checkoutTimeout = n7;
            this.connectionIsValidTimeout = n8;
            this.sharedTaskRunner = threadPoolReportingAsynchronousRunner;
            this.deferredStatementDestroyer = threadPoolReportingAsynchronousRunner2;
            this.inUseLockFetcher = this.c3p0PooledConnections ? C3P0_POOLED_CONNECION_NESTED_LOCK_LOCK_FETCHER : RESOURCE_ITSELF_IN_USE_LOCK_FETCHER;
            class PooledConnectionResourcePoolManager
            implements ResourcePool.Manager {
                ConnectionTestPath connectionTestPath;

                PooledConnectionResourcePoolManager() {
                }

                void initAfterResourcePoolConstructed() {
                    if (connectionTester == null) {
                        if (string != null) {
                            if (n8 == C3P0Defaults.connectionIsValidTimeout()) {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "Although no ConnectionTester is set, preferredTestQuery (or automaticTestTable) is also set, which can only be supported by a ConnectionTester. Reverting to use of ConnectionTester com.mchange.v2.c3p0.impl.DefaultConnectionTester.");
                                }
                                this.connectionTestPath = new ConnectionTesterConnectionTestPath(C3P0PooledConnectionPool.this.rp, C3P0Registry.getConnectionTester(DefaultConnectionTester.class.getName()), C3P0PooledConnectionPool.this.scache, string, C3P0PooledConnectionPool.this.c3p0PooledConnections);
                            } else {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "Both a preferredTestQuery (or automaticTestTable) and a non-default value of connectionIsValidTimeout are set, but only one can be simultaneously supported. Will use Connection.isValid( connectionIsValidTimeout ), and ignore test query '" + string + "'.");
                                }
                                this.connectionTestPath = new IsValidSimplifiedConnectionTestPath(C3P0PooledConnectionPool.this.rp, n8);
                            }
                        } else {
                            this.connectionTestPath = new IsValidSimplifiedConnectionTestPath(C3P0PooledConnectionPool.this.rp, n8);
                        }
                    } else {
                        if (logger.isLoggable(MLevel.WARNING) && n8 != C3P0Defaults.connectionIsValidTimeout()) {
                            logger.log(MLevel.WARNING, "A ConnectionTester '" + connectionTester + "' is explicitly set, but also a nondefault connectionIsValidTimeout (" + n8 + "). Unfortunately connectionIsValidTimeout is not supported by ConnectionTesters, and will be ignored. If you are using com.mchange.v2.c3p0.impl.DefaultConnectionTester, you may set config or system property com.mchange.v2.c3p0.impl.DefaultConnectionTester.isValidTimeout instead. Alternatively, just switch to simple isValid(...) testing by setting connectionTesterClassName to null");
                        }
                        this.connectionTestPath = new ConnectionTesterConnectionTestPath(C3P0PooledConnectionPool.this.rp, connectionTester, C3P0PooledConnectionPool.this.scache, string, C3P0PooledConnectionPool.this.c3p0PooledConnections);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object acquireResource() throws Exception {
                    Object object;
                    PooledConnection pooledConnection;
                    if (connectionCustomizer == null) {
                        pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? connectionPoolDataSource.getPooledConnection() : connectionPoolDataSource.getPooledConnection(dbAuth.getUser(), dbAuth.getPassword());
                    } else {
                        try {
                            object = (WrapperConnectionPoolDataSourceBase)((Object)connectionPoolDataSource);
                            pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(connectionCustomizer, string2) : ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(dbAuth.getUser(), dbAuth.getPassword(), connectionCustomizer, string2);
                        }
                        catch (ClassCastException classCastException) {
                            String string3 = "Cannot use a ConnectionCustomizer with a non-c3p0 ConnectionPoolDataSource. ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName();
                            throw SqlUtils.toSQLException(string3, classCastException);
                        }
                    }
                    try {
                        if (C3P0PooledConnectionPool.this.scache != null) {
                            if (C3P0PooledConnectionPool.this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)pooledConnection).initStatementCache(C3P0PooledConnectionPool.this.scache);
                            } else {
                                logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                            }
                        }
                        object = null;
                        try {
                            C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse(pooledConnection);
                            object = pooledConnection.getConnection();
                            SQLWarnings.logAndClearWarnings((Connection)object);
                        }
                        finally {
                            ConnectionUtils.attemptClose((Connection)object);
                            C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse(pooledConnection);
                        }
                        PooledConnection pooledConnection2 = pooledConnection;
                        return pooledConnection2;
                    }
                    catch (Exception exception) {
                        block20: {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "A PooledConnection was acquired, but an Exception occurred while preparing it for use. Attempting to destroy.", exception);
                            }
                            try {
                                this.destroyResource(pooledConnection, false);
                            }
                            catch (Exception exception2) {
                                if (!logger.isLoggable(MLevel.WARNING)) break block20;
                                logger.log(MLevel.WARNING, "An Exception occurred while trying to close partially acquired PooledConnection.", exception2);
                            }
                        }
                        throw exception;
                    }
                    finally {
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest(this + ".acquireResource() returning. ");
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void refurbishResourceOnCheckout(Object object) throws Exception {
                    Object object2 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(object);
                    synchronized (object2) {
                        if (connectionCustomizer != null) {
                            Connection connection = null;
                            try {
                                connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                C3P0PooledConnectionPool.this.waitMarkPhysicalConnectionInUse(connection);
                                if (bl4) {
                                    if (logger.isLoggable(MLevel.FINER)) {
                                        this.finerLoggingTestPooledConnection(object, "CHECKOUT");
                                    } else {
                                        this.testPooledConnection(object);
                                    }
                                }
                                connectionCustomizer.onCheckOut(connection, string2);
                            }
                            catch (ClassCastException classCastException) {
                                throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName(), classCastException);
                            }
                            finally {
                                C3P0PooledConnectionPool.this.unmarkPhysicalConnectionInUse(connection);
                            }
                        }
                        if (bl4) {
                            PooledConnection pooledConnection = (PooledConnection)object;
                            try {
                                C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse(pooledConnection);
                                if (logger.isLoggable(MLevel.FINER)) {
                                    this.finerLoggingTestPooledConnection(pooledConnection, "CHECKOUT");
                                } else {
                                    this.testPooledConnection(pooledConnection);
                                }
                            }
                            finally {
                                C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse(pooledConnection);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void refurbishResourceOnCheckin(Object var1_1) throws Exception {
                    var2_2 = null;
                    var3_3 = C3P0PooledConnectionPool.this.resurrectables != null && C3P0PooledConnectionPool.this.resurrectables.checkResurrectable(var1_1) != false;
                    try {
                        var4_4 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(var1_1);
                        synchronized (var4_4) {
                            if (connectionCustomizer != null) {
                                var5_5 = null;
                                try {
                                    var5_5 = ((AbstractC3P0PooledConnection)var1_1).getPhysicalConnection();
                                    C3P0PooledConnectionPool.access$700(C3P0PooledConnectionPool.this, var5_5);
                                    connectionCustomizer.onCheckIn(var5_5, string2);
                                    SQLWarnings.logAndClearWarnings(var5_5);
                                    if (!bl5 && !var3_3) ** GOTO lbl41
                                    if (C3P0PooledConnectionPool.logger.isLoggable(MLevel.FINER)) {
                                        this.finerLoggingTestPooledConnection(var1_1, "CHECKIN");
                                    }
                                    this.testPooledConnection(var1_1);
                                }
                                catch (ClassCastException var6_7) {
                                    throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + var1_1 + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName(), var6_7);
                                }
                                finally {
                                    C3P0PooledConnectionPool.access$800(C3P0PooledConnectionPool.this, var5_5);
                                }
                            } else {
                                var5_6 = (PooledConnection)var1_1;
                                var6_8 = null;
                                try {
                                    C3P0PooledConnectionPool.access$500(C3P0PooledConnectionPool.this, var5_6);
                                    var6_8 = var5_6.getConnection();
                                    SQLWarnings.logAndClearWarnings(var6_8);
                                    if (bl5 || var3_3) {
                                        if (C3P0PooledConnectionPool.logger.isLoggable(MLevel.FINER)) {
                                            this.finerLoggingTestPooledConnection(var1_1, var6_8, "CHECKIN");
                                        } else {
                                            this.testPooledConnection(var1_1, var6_8);
                                        }
                                    }
                                }
                                finally {
                                    var2_2 = var6_8;
                                    C3P0PooledConnectionPool.access$600(C3P0PooledConnectionPool.this, var5_6);
                                }
                            }
                        }
                        if (C3P0PooledConnectionPool.logger.isLoggable(MLevel.FINE) && var3_3) {
                            C3P0PooledConnectionPool.logger.log(MLevel.FINE, "A resource that had previously experienced a Connection error has been successfully resurrected on checkin: " + var1_1);
                        }
                    }
                    catch (Throwable var10_12) {
                        ConnectionUtils.attemptClose(var2_2);
                        throw var10_12;
                    }
                    ConnectionUtils.attemptClose(var2_2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void refurbishIdleResource(Object object) throws Exception {
                    Object object2 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(object);
                    synchronized (object2) {
                        PooledConnection pooledConnection = (PooledConnection)object;
                        try {
                            C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse(pooledConnection);
                            if (logger.isLoggable(MLevel.FINER)) {
                                this.finerLoggingTestPooledConnection(object, "IDLE CHECK");
                            } else {
                                this.testPooledConnection(object);
                            }
                        }
                        finally {
                            C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse(pooledConnection);
                        }
                    }
                }

                private void finerLoggingTestPooledConnection(Object object, String string3) throws Exception {
                    this.finerLoggingTestPooledConnection(object, null, string3);
                }

                private void finerLoggingTestPooledConnection(Object object, Connection connection, String string3) throws Exception {
                    logger.finer("Testing PooledConnection [" + object + "] on " + string3 + ".");
                    try {
                        this.testPooledConnection(object, connection);
                        logger.finer("Test of PooledConnection [" + object + "] on " + string3 + " has SUCCEEDED.");
                    }
                    catch (Exception exception) {
                        logger.log(MLevel.FINER, "Test of PooledConnection [" + object + "] on " + string3 + " has FAILED.", exception);
                        exception.fillInStackTrace();
                        throw exception;
                    }
                }

                private void testPooledConnection(Object object) throws Exception {
                    this.testPooledConnection(object, null);
                }

                private void testPooledConnection(Object object, Connection connection) throws Exception {
                    PooledConnection pooledConnection = (PooledConnection)object;
                    assert (!Boolean.FALSE.equals(C3P0PooledConnectionPool.this.pooledConnectionInUse(pooledConnection)));
                    this.connectionTestPath.testPooledConnection(pooledConnection, connection);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void destroyResource(Object object, boolean bl) throws Exception {
                    Object object2 = C3P0PooledConnectionPool.this.inUseLockFetcher.getInUseLock(object);
                    synchronized (object2) {
                        try {
                            block14: {
                                C3P0PooledConnectionPool.this.waitMarkPooledConnectionInUse((PooledConnection)object);
                                if (connectionCustomizer != null) {
                                    Connection connection = null;
                                    try {
                                        connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                        connectionCustomizer.onDestroy(connection, string2);
                                    }
                                    catch (ClassCastException classCastException) {
                                        throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName(), classCastException);
                                    }
                                    catch (Exception exception) {
                                        if (!logger.isLoggable(MLevel.WARNING)) break block14;
                                        logger.log(MLevel.WARNING, "An exception occurred while executing the onDestroy() method of " + connectionCustomizer + ". c3p0 will attempt to destroy the target Connection regardless, but this issue  should be investigated and fixed.", exception);
                                    }
                                }
                            }
                            if (C3P0PooledConnectionPool.this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)object).closeMaybeCheckedOut(bl);
                            } else {
                                ((PooledConnection)object).close();
                            }
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        finally {
                            C3P0PooledConnectionPool.this.unmarkPooledConnectionInUse((PooledConnection)object);
                        }
                    }
                }
            }
            PooledConnectionResourcePoolManager pooledConnectionResourcePoolManager = new PooledConnectionResourcePoolManager();
            ResourcePoolFactory resourcePoolFactory2 = resourcePoolFactory;
            synchronized (resourcePoolFactory2) {
                resourcePoolFactory.setMin(n);
                resourcePoolFactory.setMax(n2);
                resourcePoolFactory.setStart(n3);
                resourcePoolFactory.setIncrement(n4);
                resourcePoolFactory.setIdleResourceTestPeriod(n9 * 1000);
                resourcePoolFactory.setResourceMaxIdleTime(n10 * 1000);
                resourcePoolFactory.setExcessResourceMaxIdleTime(n11 * 1000);
                resourcePoolFactory.setResourceMaxAge(n12 * 1000);
                resourcePoolFactory.setExpirationEnforcementDelay(n13 * 1000);
                resourcePoolFactory.setDestroyOverdueResourceTime(n14 * 1000);
                resourcePoolFactory.setDebugStoreCheckoutStackTrace(bl2);
                resourcePoolFactory.setForceSynchronousCheckins(bl3);
                resourcePoolFactory.setAcquisitionRetryAttempts(n5);
                resourcePoolFactory.setAcquisitionRetryDelay(n6);
                resourcePoolFactory.setBreakOnAcquisitionFailure(bl);
                this.rp = resourcePoolFactory.createPool(pooledConnectionResourcePoolManager);
            }
            pooledConnectionResourcePoolManager.initAfterResourcePoolConstructed();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            PooledConnection pooledConnection = (PooledConnection)this.checkoutAndMarkConnectionInUse();
            pooledConnection.addConnectionEventListener(this.cl);
            this.markBeginRequest(pooledConnection);
            return pooledConnection;
        }
        catch (TimeoutException timeoutException) {
            throw SqlUtils.toSQLException("An attempt by a client to checkout a Connection has timed out.", timeoutException);
        }
        catch (CannotAcquireResourceException cannotAcquireResourceException) {
            throw SqlUtils.toSQLException("Connections could not be acquired from the underlying database!", "08001", cannotAcquireResourceException);
        }
        catch (Exception exception) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    private void waitMarkPhysicalConnectionInUse(Connection connection) throws InterruptedException {
        if (this.scache != null) {
            this.scache.waitMarkConnectionInUse(connection);
        }
    }

    private boolean tryMarkPhysicalConnectionInUse(Connection connection) {
        return this.scache != null ? this.scache.tryMarkConnectionInUse(connection) : true;
    }

    private void unmarkPhysicalConnectionInUse(Connection connection) {
        if (this.scache != null) {
            this.scache.unmarkConnectionInUse(connection);
        }
    }

    private void waitMarkPooledConnectionInUse(PooledConnection pooledConnection) throws InterruptedException {
        if (this.c3p0PooledConnections) {
            this.waitMarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
    }

    private boolean tryMarkPooledConnectionInUse(PooledConnection pooledConnection) {
        if (this.c3p0PooledConnections) {
            return this.tryMarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
        return true;
    }

    private void unmarkPooledConnectionInUse(PooledConnection pooledConnection) {
        if (this.c3p0PooledConnections) {
            this.unmarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
    }

    private Boolean physicalConnectionInUse(Connection connection) throws InterruptedException {
        if (connection != null && this.scache != null) {
            return this.scache.inUse(connection);
        }
        return null;
    }

    private Boolean pooledConnectionInUse(PooledConnection pooledConnection) throws InterruptedException {
        if (pooledConnection != null && this.scache != null) {
            return this.scache.inUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkoutAndMarkConnectionInUse() throws TimeoutException, CannotAcquireResourceException, ResourcePoolException, InterruptedException {
        Object object = null;
        boolean bl = false;
        while (!bl) {
            try {
                object = this.rp.checkoutResource(this.checkoutTimeout);
                if (object instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)object;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    bl = this.tryMarkPhysicalConnectionInUse(connection);
                    continue;
                }
                bl = true;
            }
            finally {
                try {
                    if (bl || object == null) continue;
                    this.rp.checkinResource(object);
                }
                catch (Exception exception) {
                    logger.log(MLevel.WARNING, "Failed to check in a Connection that was unusable due to pending Statement closes.", exception);
                }
            }
        }
        return object;
    }

    private void unmarkConnectionInUseAndCheckin(PooledConnection pooledConnection) throws ResourcePoolException {
        block3: {
            if (this.scache != null) {
                try {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    this.unmarkPhysicalConnectionInUse(connection);
                }
                catch (ClassCastException classCastException) {
                    if (!logger.isLoggable(MLevel.SEVERE)) break block3;
                    logger.log(MLevel.SEVERE, "You are checking a non-c3p0 PooledConnection implementation intoa c3p0 PooledConnectionPool instance that expects only c3p0-generated PooledConnections.This isn't good, and may indicate a c3p0 bug, or an unusual (and unspported) use of the c3p0 library.", classCastException);
                }
            }
        }
        this.rp.checkinResource(pooledConnection);
    }

    private void checkinPooledConnection(PooledConnection pooledConnection) throws SQLException {
        try {
            pooledConnection.removeConnectionEventListener(this.cl);
            this.unmarkConnectionInUseAndCheckin(pooledConnection);
            this.markEndRequest(pooledConnection);
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public float getEffectivePropertyCycle() throws SQLException {
        try {
            return (float)this.rp.getEffectiveExpirationEnforcementDelay() / 1000.0f;
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public int getNumThreadsAwaitingCheckout() throws SQLException {
        try {
            return this.rp.getNumCheckoutWaiters();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public int getStatementCacheNumStatements() {
        return this.scache == null ? 0 : this.scache.getNumStatements();
    }

    public int getStatementCacheNumCheckedOut() {
        return this.scache == null ? 0 : this.scache.getNumStatementsCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatements() {
        return this.scache == null ? 0 : this.scache.getNumConnectionsWithCachedStatements();
    }

    public String dumpStatementCacheStatus() {
        return this.scache == null ? "Statement caching disabled." : this.scache.dumpStatementCacheStatus();
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean bl) throws SQLException {
        Exception exception = null;
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException sQLException) {
            exception = sQLException;
        }
        try {
            this.rp.close(bl);
        }
        catch (ResourcePoolException resourcePoolException) {
            if (exception != null && logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while closing the StatementCache.", exception);
            }
            exception = resourcePoolException;
        }
        if (exception != null) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumBusyConnections() throws SQLException {
        try {
            return this.rp.getAwaitingCheckinNotExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getStartTime() throws SQLException {
        try {
            return this.rp.getStartTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getUpTime() throws SQLException {
        try {
            return this.rp.getUpTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedCheckins() throws SQLException {
        try {
            return this.rp.getNumFailedCheckins();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedCheckouts() throws SQLException {
        try {
            return this.rp.getNumFailedCheckouts();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedIdleTests() throws SQLException {
        try {
            return this.rp.getNumFailedIdleTests();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastCheckinFailure() throws SQLException {
        try {
            return this.rp.getLastCheckinFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastCheckoutFailure() throws SQLException {
        try {
            return this.rp.getLastCheckoutFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastIdleTestFailure() throws SQLException {
        try {
            return this.rp.getLastIdleCheckFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastConnectionTestFailure() throws SQLException {
        try {
            return this.rp.getLastResourceTestFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastAcquisitionFailure() throws SQLException {
        try {
            return this.rp.getLastAcquisitionFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            this.doCheckinResource(connectionEvent);
        }

        private void doCheckinResource(ConnectionEvent connectionEvent) {
            try {
                C3P0PooledConnectionPool.this.checkinPooledConnection((PooledConnection)connectionEvent.getSource());
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", exception);
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            int n = (pooledConnection = (PooledConnection)connectionEvent.getSource()) instanceof NewPooledConnection ? ((NewPooledConnection)pooledConnection).getConnectionStatus() : -1;
            int n2 = n;
            this.doMarkPoolStatus(pooledConnection, n2);
        }

        private void doMarkPoolStatus(PooledConnection pooledConnection, int n) {
            try {
                switch (n) {
                    case 0: {
                        throw new RuntimeException("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        if (C3P0PooledConnectionPool.this.resurrectables == null) {
                            C3P0PooledConnectionPool.this.rp.markBroken(pooledConnection);
                            break;
                        }
                        C3P0PooledConnectionPool.this.resurrectables.markResurrectable(pooledConnection);
                        break;
                    }
                    case -8: {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.warning("A ConnectionTest has failed, reporting that all previously acquired Connections are likely invalid. The pool will be reset.");
                        }
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") returned invalid status (" + n + ").");
                    }
                }
            }
            catch (ResourcePoolException resourcePoolException) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", resourcePoolException);
            }
        }
    }

    private static class LiveRequestBoundaryMarker
    implements RequestBoundaryMarker {
        private LiveRequestBoundaryMarker() {
        }

        @Override
        public void attemptNotifyBeginRequest(PooledConnection pooledConnection) {
            if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                try {
                    connection.beginRequest();
                    logger.log(MLevel.FINEST, "beginRequest method called");
                }
                catch (AbstractMethodError abstractMethodError) {
                    logger.log(MLevel.WARNING, "AbstractMethodError invoking beginRequest method for Connction, even though Connections were tested for the presence of this method previously.", abstractMethodError);
                }
                catch (Exception exception) {
                    logger.log(MLevel.WARNING, "Error invoking beginRequest method for connection", exception);
                }
            }
        }

        @Override
        public void attemptNotifyEndRequest(PooledConnection pooledConnection) {
            if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                try {
                    connection.endRequest();
                    logger.log(MLevel.FINEST, "endRequest method called");
                }
                catch (AbstractMethodError abstractMethodError) {
                    logger.log(MLevel.WARNING, "AbstractMethodError invoking endRequest method for Connction, even though Connections were tested for the presence of this method previously.", abstractMethodError);
                }
                catch (Exception exception) {
                    logger.log(MLevel.WARNING, "Error invoking endRequest method for connection", exception);
                }
            }
        }
    }

    private static class NoOpRequestBoundaryMarker
    implements RequestBoundaryMarker {
        private NoOpRequestBoundaryMarker() {
        }

        @Override
        public void attemptNotifyBeginRequest(PooledConnection pooledConnection) {
        }

        @Override
        public void attemptNotifyEndRequest(PooledConnection pooledConnection) {
        }
    }

    private static interface RequestBoundaryMarker {
        public void attemptNotifyBeginRequest(PooledConnection var1);

        public void attemptNotifyEndRequest(PooledConnection var1);
    }

    private static class C3P0PooledConnectionNestedLockLockFetcher
    implements InUseLockFetcher {
        private C3P0PooledConnectionNestedLockLockFetcher() {
        }

        @Override
        public Object getInUseLock(Object object) {
            return ((AbstractC3P0PooledConnection)object).inInternalUseLock;
        }
    }

    private static class ResourceItselfInUseLockFetcher
    implements InUseLockFetcher {
        private ResourceItselfInUseLockFetcher() {
        }

        @Override
        public Object getInUseLock(Object object) {
            return object;
        }
    }

    private static interface InUseLockFetcher {
        public Object getInUseLock(Object var1);
    }

    private static class Resurrectables {
        WeakHashMap candidates = new WeakHashMap();

        private Resurrectables() {
        }

        public synchronized void markResurrectable(Object object) {
            this.candidates.put(object, this);
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Marked broken resource resurrectable: " + object);
            }
        }

        public synchronized boolean checkResurrectable(Object object) {
            boolean bl;
            boolean bl2 = bl = this.candidates.remove(object) != null;
            if (logger.isLoggable(MLevel.FINER) && bl) {
                logger.log(MLevel.FINER, "Found and cleared resurrectable resource: " + object);
            }
            return bl;
        }
    }
}

