/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;

public class SpanRegexQueryWrapper
extends SpanQueryWrapper {
    private SpanQuery query;
    public String error = null;

    public SpanRegexQueryWrapper(String field, String re) {
        this(field, re, 65535, false);
    }

    public SpanRegexQueryWrapper(String field, String re, int flags) {
        this(field, re, flags, false);
    }

    public SpanRegexQueryWrapper(String field, String re, boolean caseinsensitive) {
        this(field, re, 65535, caseinsensitive);
    }

    public SpanRegexQueryWrapper(String field, String re, int flags, boolean caseinsensitive) {
        if (caseinsensitive) {
            if (re.startsWith("s:")) {
                re = re.replaceFirst("s:", "i:");
            }
            re = re.toLowerCase();
        }
        try {
            RegexpQuery requery = new RegexpQuery(new Term(field, re), flags);
            this.query = new SpanMultiTermQueryWrapper<RegexpQuery>(requery);
        }
        catch (Exception e) {
            this.error = e.getLocalizedMessage();
        }
    }

    public SpanRegexQueryWrapper(RegexpQuery requery) {
        this.query = new SpanMultiTermQueryWrapper<RegexpQuery>(requery);
    }

    @Override
    public SpanQuery toFragmentQuery() {
        return this.query;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

